<section class="page-contents">
<div class="container">
<?php if(!defined('IN_PHPVMS') && IN_PHPVMS !== true) { die(); } ?>
<div class="deepBlue-block clearfix">
        <div class="deepBlue-blockheader">
            <h3 class="t">PIREP's List (<?php echo $userinfo->totalflights?>)</h3>
        </div>
        <div class="deepBlue-blockcontent"><div>
<p><?php if(isset($descrip)) { echo $descrip; }?></p>
<?php
if(!$pirep_list) {
	echo '<br />';
echo '<div align="center">';
echo '<div class="alert alert-danger"><strong>No reports have been found. Pilot might have cold feet!</strong></div>';
echo '<div>';
	return;
}
?>
<script type="text/javascript">
$(document).ready(function() {
    oTable = $('#deepBlue_View_All_PIREPS').dataTable({
        "bJQueryUI": true,
        "sPaginationType": "full_numbers"
    });
} );

</script>
<table id="deepBlue_View_All_PIREPS" width="100%" border="0" cellspacing="0" cellpadding="0" class="deepBlue_table">
<thead>
<tr>
	<th>Flight Number</th>
	<th>Departure</th>
	<th>Arrival</th>
	<th>Aircraft</th>
	<th>Flight Time</th>
	<th>Submitted</th>
	<th>Status</th>
	<?php
	// Only show this column if they're logged in, and the pilot viewing is the
	//	owner/submitter of the PIREPs
	if(Auth::LoggedIn() && Auth::$pilot->pilotid == $pilot->pilotid) {
		echo '<th>Options</th>';
	}
	?>
</tr>
</thead>
<tbody>
<?php
foreach($pirep_list as $pirep) {
?>
<tr>
	<td align="center">
		<a href="<?php echo url('/pireps/view/'.$pirep->pirepid);?>"><?php echo $pirep->code . $pirep->flightnum; ?></a>
	</td>
	<td align="center"><?php echo $pirep->depicao; ?></td>
	<td align="center"><?php echo $pirep->arricao; ?></td>
	<td align="center"><?php echo $pirep->aircraft . " ($pirep->registration)"; ?></td>
	<td align="center"><?php echo $pirep->flighttime; ?></td>
	<td align="center"><?php echo date(DATE_FORMAT, $pirep->submitdate); ?></td>
	<td align="center">
		<?php
		
		if($pirep->accepted == PIREP_ACCEPTED) {
            echo '<span class="label label-important"><font color="green"><i class="fa fa-check-square" aria-hidden="true"></i>  Accepted</div>';
		} elseif($pirep->accepted == PIREP_REJECTED) {
            echo '<span class="label label-important"><font color="cc0000"><i class="fa fa-minus-circle" aria-hidden="true"></i> Rejected</div>';
		} elseif($pirep->accepted == PIREP_PENDING) {
            echo '<span class="label label-important"><font color="835C3B"><i class="fa fa-exclamation-circle" aria-hidden="true"></i> Approval Pending</div>';
		} elseif($pirep->accepted == PIREP_INPROGRESS) {
            echo '<div id="error">Flight in Progress</div>';
		}
			
		
		?>
	</td>
	<?php
	// Only show this column if they're logged in, and the pilot viewing is the
	//	owner/submitter of the PIREPs
	if(Auth::LoggedIn() && Auth::$pilot->pilotid == $pirep->pilotid) {
		?>
	<td align="right">
		<a href="<?php echo url('/pireps/addcomment?id='.$pirep->pirepid);?>"><i class="fa fa-commenting" aria-hidden="true" style="color:#0C336E"></i> Add Comment</a><br />
		<a href="<?php echo url('/pireps/editpirep?id='.$pirep->pirepid);?>"><i class="fa fa-pencil-square" aria-hidden="true" style="color:#0C336E"></i> Edit PIREP</a>
	</td>
	<?php
	}
	?>
</tr>
<?php
}
?>
</tbody>
</table>
</div>
</div></div>
</div>
</section>