<?php

namespace Modules\DisposableTools\Widgets;

use App\Contracts\Widget;
use App\Models\Pirep;
use App\Models\Enums\PirepState;
use App\Models\Enums\PirepStatus;

class AirportPireps extends Widget
{
  protected $config = ['location' => 'ZZZZ', 'count' => null];

  public function run()
  {
    if (!is_numeric($this->config['count'])) {
      $this->config['count'] = 250;
    }

    $pireps = Pirep::where(['dpt_airport_id' => $this->config['location'], 'state' => PirepState::ACCEPTED, 'status' => PirepStatus::ARRIVED])
                ->orWhere('arr_airport_id', $this->config['location'])->where(['state' => PirepState::ACCEPTED, 'status' => PirepStatus::ARRIVED])
                ->orderBy('submitted_at', 'desc')
                ->take($this->config['count'])
                ->get();

    return view('DisposableTools::airport_pireps', [
      'pireps' => $pireps,
      'config' => $this->config,
    ]);
  }
}
