<?php

namespace Modules\DisposableTools\Widgets;

use App\Contracts\Widget;
use App\Models\Airline;
use App\Models\Pirep;
use App\Models\Enums\PirepState;
use Carbon\Carbon;

class TopAirlines extends Widget
{
  protected $config = ['count' => 3, 'type' => 'flights', 'period' => null];

  public function run()
  {
    $period = $this->config['period'];
    $type = $this->config['type'];

    $airlines_array = Airline::where('active', 1)->pluck('id')->toArray();

    $now = Carbon::now();

    if ($period === 'currentm' || $period === 'currenty') { $b_date = $now; }
    elseif ($period === 'lastm') { $b_date = $now->subMonthNoOverflow(); }
    elseif ($period === 'prevm') { $b_date = $now->subMonthsNoOverflow(2); }
    elseif ($period === 'lasty') { $b_date = $now->subYearNoOverflow(); }
    elseif ($period === 'prevy') { $b_date = $now->subYearsNoOverflow(2); }

    if ($period === 'currenty' || $period === 'lasty' || $period === 'prevy') {
      $s_date = $b_date->startOfYear();
      $e_date = $b_date->copy()->endOfYear();
      $period = $b_date->format('Y');
    } elseif ($period === 'currentm' || $period === 'lastm' || $period === 'prevm') {
      $s_date = $b_date->startOfMonth();
      $e_date = $b_date->copy()->endOfMonth();
      $period = $b_date->format('F');
    }

    if ($type === 'flights') {
      $select_Raw = 'airline_id, count(airline_id) as totals';
      $rtype = trans_choice('common.flight', 2);
    } elseif ($type === 'distance') {
      $select_Raw = 'airline_id, sum(distance) as totals';
      $rtype = __('common.distance');
    } elseif ($type === 'time') {
      $select_Raw = 'airline_id, sum(flight_time) as totals';
      $rtype = __('pireps.flighttime');
    } elseif ($type === 'landingrate') {
      $select_Raw = 'airline_id, avg(landing_rate) as totals';
      $rtype = __('DisposableTools::common.avglanding');
    } elseif ($type === 'score') {
      $select_Raw = 'airline_id, avg(score) as totals';
      $rtype = __('DisposableTools::common.avgscore');
    }

    if (isset($period)) {
      $tairlines = Pirep::with('airline')->selectRaw($select_Raw)
        ->where('state', PirepState::ACCEPTED)
        ->whereIn('airline_id', $airlines_array)
        ->whereBetween('created_at', [$s_date, $e_date])
        ->orderBy('totals', 'desc')->groupBy('airline_id')
        ->take($this->config['count'])->get();
    } else {
      $tairlines = Pirep::with('airline')->selectRaw($select_Raw)
        ->where('state', PirepState::ACCEPTED)
        ->whereIn('airline_id', $airlines_array)
        ->orderBy('totals', 'desc')->groupBy('airline_id')
        ->take($this->config['count'])->get();
    }

    return view('DisposableTools::top_airlines', [
      'config'    => $this->config,
      'rperiod'   => $period,
      'rtype'     => $rtype,
      'tairlines' => $tairlines,
    ]);
  }
}
