@extends('app')
@section('title', 'Landing Rates')

@section('content')
  <div class="card mb-2">
    <div class="card-header p-1">
      <h5 class="m-1">
        About Landing Rates
        <i class="fas fa-plane-arrival float-end"></i>
      </h5>
    </div>
    <div class="card-body p-1">
      <p>This page tries to explain the &quot;landing rate&quot; calculation and how we see it here at&nbsp;{{ config('app.name') }}... First things first, and it is simple ; <strong>Do not try to achieve a &quot;butter smooth&quot; landing !</strong> You will overshoot the threshold and have a long landing, bu sure of that. Even in long runways, you may easily overrun it, the smoother you try to land, the longer time and distance it will take for your plane to stop. Also do not try to make a low/slow approach to have a smooth landing on the touchdown zone. The minimums, approach glide slopes and angles are there for a reason.</p>
      <p><strong>In simple terms, we do not and will not congratulate you for a smooth landing !</strong> In fact, you most probably will be punished for that.</p>
      <p>Technically during a normal landing, your vertical speed will be around 5/6 feet per second, this gives us a round number of 300-360 feet/min... Anything slightly above it may be little hard on the passengers but will not hurt the aircraft, but anyting below this will make you leave valuable runway surface behind.</p>
      <p>Just for quick info you may check the below table for how we will implement the landing rate calculations;<br />
      <br />
      <table class="table table-sm table-borderless table-striped text-center align-middle mb-2">
        <tr>
          <th class="text-start">Description</th>
          <th>Min</th>
          <th>Max</th>
          <th>Display</th>
        </tr>
        <tr>
          <td class="text-start">Unacceptable / May cause structral stress and damage to aircraft&nbsp;&nbsp;</td>
          <td>0</td>
          <td>-50</td>
          <td><i class="fas fa-angry fa-2x text-danger"></i></td>
        </tr>
        <tr>
          <td class="text-start">Soft - Probably a long landing !</td>
          <td>-50</td>
          <td>-100</td>
          <td><i class="fas fa-frown fa-2x text-secondary"></i></td>
        </tr>
        <tr>
          <td class="text-start">Slightly Soft</td>
          <td>-100</td>
          <td>-250</td>
          <td ><i class="fas fa-meh fa-2x text-info"></i></td>
        </tr>
        <tr>
          <td class="text-start">Acceptable Range</td>
          <td>-250</td>
          <td>-400</td>
          <td ><i class="fas fa-smile fa-2x text-success"></i></td>
        </tr>
        <tr>
          <td class="text-start">Slightly Hard</td>
          <td>-400</td>
          <td>-500</td>
          <td ><i class="fas fa-meh fa-2x text-info"></i></td>
        </tr>
        <tr>
          <td class="text-start">Hard Landing / Needs tech evalulation of aircraft</td>
          <td>-500</td>
          <td>&nbsp;and above</td>
          <td ><i class="fas fa-angry fa-2x text-danger"></i></td>
        </tr>
      </table>
      <p>So, your landing will be evaluated and scored for each of your reported flights... Also your average landing rate will be calculated and displayed with a color code, as long as you stay in the green/acceptable zone all will be ok. Anything above or below that zone will be displayed with some fancy colors and this will affect your overall scores.</p>
      <p>Please remember, we are not here to push things above their limits and we encourage &quot;Firm Landing&quot; logic always. We are here to live a hobby, as real as it gets and executing proper landings is a key to this.</p>
      <p>Safe flights</p>
    </div>
  </div>
@endsection
