<div class="row">
  <div class="col-md-8">
    <div class="card mb-1">
      <div class="card-header p-1">
        <h5 class="m-1">vmsAcars Setup and Settings</h5>
      </div>
      <div class="card-body p-1">
        <ul>
          <li>Download vmsAcars</li>
          <li>Unpack/Extract the contents to a non Windows protected folder (Program Files, ProgramData, Windows are "Protected Folders")</li>
          <li>You can create a shortcut to <b>acars.exe</b> at your desktop and/or pin it to your start menu if you wish so</li>
          <li>Run vmsAcars. After update checks you will reach the Settings during initial run</li>
        </ul>
        <b>Settings : Remote Configuration</b>
        <ul>
          <li>phpVMS URL : <b>{{ config('app.url') }}</b></li>
          <li>Your API Key : Get your key from your profile page</li>
          <li>Check Beta Version : If you want to participate in beta tests enable this, if not leave it off to get latest stable versions only</li>
          <li>Show Discord Status Update : If you are using Discord and want to share your flight details as Rich Presence messages enable this</li>
          <li>Automatically Check For Scenery Changes : Enable if you want acars to check for any scenery changes in your sim, advised to be disabled</li>
        </ul>
        <b>Settings : Simulator</b>
        <ul>
          <li>Active Simulator : Select the simulator you wish to use (Fs2004 / FsX / Prepar3D / X-Plane and MsFs are supported)</li>
          <li>... Folder Path : Full path to the main folder of selected sim (Ex: D:\Aviation\Prepar3D v5)</li>
        </ul>
        <b>Settings : Scenery</b>
        <ul>
          <li>Re-Sync Scenery : This button will start the sync process for selected sim (reads simulator scenery database and creates/updates acars database) <b>(*)</b></li>
        </ul>
      </div>
    </div>
    <div class="card mb-1">
      <div class="card-body p-1">
        <b>Fs2004 / FsX / Prepar3D</b>
        <ul>
          <li>Be sure you have the latest <b>FsUipc</b> compatible with your sim is installed</li>
          <li>Download the compatible version of MakeRunways pack for your sim</li>
          <li>Unpack it to the root of your simulator (Exp: D:\Aviation\Fs9 )</li>
          <li>Run MakeRwys.exe file <b>with administrator rights</b> and wait for the process to finish</li>
          <li>Check your Acars Settins / Active Simulator and click <b>Re-Sync Scenery</b> button to start the sync</li>
        </ul>
        <b>X-Plane</b>
        <ul>
          <li>Copy <b>AcarsConnect</b> folder from Acars/X-Plane to your X-Plane\Resources\Plugins folder</li>
          <li>Check your Acars Settins / Active Simulator and click <b>Re-Sync Scenery</b> button to start the sync</li>
        </ul>
        <b>MsFs 2020</b>
        <ul>
          <li>Check your Acars Settins / Active Simulator and click <b>Re-Sync Scenery</b> button to start the sync</li>
        </ul>
        <p><b>(*)</b>
          Re-Sync of your scenery is mandatory for the initial setup and you can use it as long as you wish. But whenever you install a new airport to your sim, which was not there before (technically) 
          then you need to complete the Re-Sync process again for that new airport to be recognized by acars. It is not necessary to re-sync after every scenery update but if you wish you can do it.
          Also it is advised to re-sync when important changes to airports are done, like a new runway is added or an old one gets removed etc.
        </p>
      </div>
    </div>
  </div>
  <div class="col-md-4">
    <div class="card-body p-0">
      <img class="img-fluid rounded border border-dark" src="{{ public_asset('/image/acars/acars_settings.png') }}" alt=""/>
    </div>
  </div>
</div>