@extends('app')
@section('title', 'Operations Manual')

@section('content')
  <div class="row mb-2">
    <div class="col">
      <ul class="nav nav-pills nav-justified mb-1" id="pills-tab" role="tablist">
        <li class="nav-item mx-1" role="presentation">
          <a class="nav-link p-1 active" id="pills-setup-tab" data-toggle="pill" href="#pills-setup" role="tab" aria-controls="pills-setup" aria-selected="true">
            Acars Setup
          </a>
        </li>
        <li class="nav-item mx-1" role="presentation">
          <a class="nav-link p-1" id="pills-schedule-tab" data-toggle="pill" href="#pills-schedule" role="tab" aria-controls="pills-schedule" aria-selected="false">
            Defined Flights (Schedule, Tours etc.)
          </a>
        </li>
        <li class="nav-item mx-1" role="presentation">
          <a class="nav-link p-1" id="pills-freeflight-tab" data-toggle="pill" href="#pills-freeflight" role="tab" aria-controls="pills-freeflight" aria-selected="false">
            Free Flights
          </a>
        </li>
        <li class="nav-item mx-1" role="presentation">
          <a class="nav-link p-1" id="pills-bids-tab" data-toggle="pill" href="#pills-bids" role="tab" aria-controls="pills-bids" aria-selected="false">
            Bids
          </a>
        </li>
        <li class="nav-item mx-1" role="presentation">
          <a class="nav-link p-1" id="pills-pirep-tab" data-toggle="pill" href="#pills-pirep" role="tab" aria-controls="pills-pirep" aria-selected="false">
            Starting a Flight and Reporting
          </a>
        </li>
        <li class="nav-item mx-1" role="presentation">
          <a class="nav-link p-1" id="pills-checks-tab" data-toggle="pill" href="#pills-checks" role="tab" aria-controls="pills-checks" aria-selected="false">
            Evaluation and Checks
          </a>
        </li>
      </ul>
    </div>
  </div>

  <div class="row mb-1">
    <div class="col">
      <div class="tab-content" id="pills-tabContent">
        {{-- Setup --}}
        <div class="tab-pane fade show active" id="pills-setup" role="tabpanel" aria-labelledby="pills-setup-tab">
          @include('DSpecial::pages.ops_manual_acars')
        </div>
        {{-- Search --}}
        <div class="tab-pane fade" id="pills-schedule" role="tabpanel" aria-labelledby="pills-schedule-tab">
          @include('DSpecial::pages.ops_manual_schedule')
        </div>
        {{-- Free Flight --}}
        <div class="tab-pane fade" id="pills-freeflight" role="tabpanel" aria-labelledby="pills-freeflight-tab">
          @include('DSpecial::pages.ops_manual_freeflight')
        </div>
        {{-- Bid --}}
        <div class="tab-pane fade" id="pills-bids" role="tabpanel" aria-labelledby="pills-bids-tab">
          @include('DSpecial::pages.ops_manual_bids')
        </div>
        {{-- Pirep --}}
        <div class="tab-pane fade" id="pills-pirep" role="tabpanel" aria-labelledby="pills-pirep-tab">
          @include('DSpecial::pages.ops_manual_pirep')
        </div>
        {{-- Checks --}}
        <div class="tab-pane fade" id="pills-checks" role="tabpanel" aria-labelledby="pills-checks-tab">
          @include('DSpecial::pages.ops_manual_checks')
        </div>
      </div>
    </div>
  </div>
@endsection
