<div class="row">
  <div class="col-md-8">
    <div class="card mb-2">
      <div class="card-header p-1">
        <h5 class="m-1">Scoring, Checks and General Info</h5>
      </div>
      <div class="card-body p-1">
        <p>All flights start with <b>100 points</b> and there are no difference for any flight type (like Tours vs Free Flights etc).
        Main purpose of scoring is to find out our mistakes, learn from them and improve our piloting skills.</p>
        <p>At this respect, scoring is not a tool for punishment or not a criteria for pirep acceptance. 
          Your pipeps may be rejected due to several reasons, which are mainly technical and related to errors which may affect overall stability of the system.
          Please do not hesitate to ask if one of your pireps gets rejected, also staff may contact you if they found a technical fault in your pireps/logs 
          to find the root cause and to fix the problem for good.
        </p>
      </div>
    </div>
    <div class="card mb-2">
      <div class="card-body p-1">
        <p>Acars checks affecting pirep score</p>
        <ul class="nav nav-pills mb-3" id="pills-tab" role="tablist">
          <li class="nav-item mx-1" role="presentation">
            <a class="nav-link p-1 active" id="pills-general-tab" data-toggle="pill" href="#pills-general" role="tab" aria-controls="pills-general" aria-selected="true">
              General Limitations
            </a>
          </li>
          <li class="nav-item mx-1" role="presentation">
            <a class="nav-link p-1" id="pills-lights-tab" data-toggle="pill" href="#pills-lights" role="tab" aria-controls="pills-lights" aria-selected="false">
              Aircraft Lights
            </a>
          </li>
          <li class="nav-item mx-1" role="presentation">
            <a class="nav-link p-1" id="pills-sim-tab" data-toggle="pill" href="#pills-sim" role="tab" aria-controls="pills-sim" aria-selected="false">
              Simulator Functions
            </a>
          </li>
        </ul>
        <div class="tab-content" id="pills-tabContent">
          <div class="tab-pane fade show active" id="pills-general" role="tabpanel" aria-labelledby="pills-general-tab">
            <ul>
              <li>Taxi Speed: Max 30 kts</li>
              <li>Roll: Max 60&deg; (left/right)</li>
              <li>Pitch: Max 30&deg; (up/down)</li>
              <li>G-Force: Max 3 m/s&sup2;</li>
              <li>Speed: Max 250 kts below 10k feet</li>
              <li>Overspeed: Not allowed</li>
              <li>Stall: Not allowed</li>
              <li>Hard Landing: Any landing above 500 ft/m will be considered as hard</li>
              <li>Reverser: Not allowed during flight. Should be OFF below 60 kts after landing</li>
            </ul>
          </div>
          <div class="tab-pane fade" id="pills-lights" role="tabpanel" aria-labelledby="pills-lights-tab">
            <ul>
              <b>Entire Flight</b>
              <li>Navigation Lights: On as long as the crew is in cockpit and aircraft is electrically powered</li>
              <li>Logo Lights: At pilot's discretion</li>
              <li>Beacon Lights: On as long as any of the engines running (should be on before pushback, off after confirmed idle n2 / no fuel flow)</li>
              <b>Apron / Taxi Out</b>
              <li>Taxi Lights: At pilot's discretion after Pushback</li>
              <li>Runway Lights: At pilot's discretion after Pushback</li>
              <li>Landing Lights: Off</li>
              <li>Strobe Lights: Off except runway crossings</li>
              <b>Take Off and Departure</b>
              <li>Taxi Lights: On, prefably with Full Intensity, Off after take off</li>
              <li>Runway Lights: At pilot's discretion, Off after take off</li>
              <li>Landing Lights: On, At pilot's discretion after 1500 ft, Off after 10k feet during climb</li>
              <li>Strobe Lights: On (during the entire flight)</li>
              <b>Descend and Landing</b>
              <li>Taxi Lights: On after Gear Down, prefably at Full Intensity during landing</li>
              <li>Runway Lights: At pilot's discretion after Gear Down</li>
              <li>Landing Lights: At pilot's discretion below 10k feet, On below 1500 ft (until leaving the runway)</li>
              <li>Strobe Lights: On until leaving the runway</li>
              <b>Apron / Taxi In</b>
              <li>Taxi Lights: At pilot's discretion, Off after reaching the stand</li>
              <li>Runway Lights: At pilot's discretion, Off after reaching the stand</li>
              <li>Landing Lights: Off</li>
              <li>Strobe Lights: Off except runway crossings during taxi in</li>
            </ul>
          </div>
          <div class="tab-pane fade" id="pills-sim" role="tabpanel" aria-labelledby="pills-sim-tab">
            <ul>
              <li>Fuel Refill: Not allowed</li>
              <li>Slew / Movement: Not allowed</li>
              <li>Time Factor: Not allowed anything different from 1x / Normal speed (including oceanic flights)</li>
              <li>Pause: At pilot's discretion except online flights (IVAO/VATSIM etc)</li>
            </ul>
          </div>
        </div>
      </div>
    </div>
    <div class="card mb-2">
      <div class="card-body p-1">
        <p>Checks done by the system but not affecting scoring</p>
        <ul>
          <li>Operational weights (Ramp Weight, TakeOff Weight, Landing Weight)</li>
          <li>Flap and Gear Retraction/Extraction speed limits</li>
          <li>Tire speed limits</li>
          <li>Operational fuel figures (Final Reserve, Extra Fuel vb)</li>
          <li>Aircraft type and registration vs flight plan</li>
          <li>Aircraft type vs flight/pirep</li>
          <li>Aircraft maintenance checks</li>
          <li>Crew duty time limits (soon)</li>
        </ul>
      </div>
    </div>
  </div>
  <div class="col-md-4">
    <div class="card-body p-0">
      {{-- Intentionally Left Blank --}}
    </div>
  </div>
</div>