<div class="row">
  <div class="col-md-8">
    <div class="card mb-2">
      <div class="card-header p-1">
        <h5 class="m-1">Free Flights</h5>
      </div>
      <div class="card-body p-1">
        <p>
          Any flight outside our pre-defined ones (like schedules and tours) are considered as a "Free Flight".<br>
          And you are free to choose your destination anytime you wish to execute your personal free flight
        </p>
        <ul>
          <li>Click <b>"Free Flight"</b> button from Dashboard (or the <b>"My Flight"</b> button from personal dropdown menu)</li>
          <li>Select the airline you wish to fly (Your current airline will be pre selected)</li>
          <li>Enter the flight number you wish to use (Only numeric values are allowed)</li>
          <li>Enter the callsign you wish to use (Optional | Alphanumeric values are allowed)</li>
          <li>Enter the departure airport ICAO (You may be limited with your current airport <b>(*)</b>, this field is pre-defined)</li>
          <li>Enter the arrival airport ICAO</li>
          <li>Select the aircraft (Optional and may list only the available ones at your location)</li>
          <li>Click <b>Update & Proceed To Flight Planning</b> button</li>
          <li>At this point according to your previous selections you will either see the full SimBrief OFP generation form or the Aircraft selection dropdown</li>
        </ul>
        <ul class="nav nav-pills mb-3" id="pills-tab" role="tablist">
          <li class="nav-item mx-1" role="presentation">
            <a class="nav-link p-1 active" id="pills-wsb-tab" data-toggle="pill" href="#pills-wsb" role="tab" aria-controls="pills-wsb" aria-selected="true">
              Proceed with SimBrief planning via web services
            </a>
          </li>
          <li class="nav-item mx-1" role="presentation">
            <a class="nav-link p-1" id="pills-wosb-tab" data-toggle="pill" href="#pills-wosb" role="tab" aria-controls="pills-wosb" aria-selected="false">
              Proceed without planning via web
            </a>
          </li>
          <li class="nav-item mx-1" role="presentation">
            <a class="nav-link p-1" id="pills-acars-tab" data-toggle="pill" href="#pills-acars" role="tab" aria-controls="pills-acars" aria-selected="false">
              Proceed with Acars (leave web)
            </a>
          </li>
        </ul>
        <div class="tab-content" id="pills-tabContent">
          <div class="tab-pane fade show active" id="pills-wsb" role="tabpanel" aria-labelledby="pills-wsb-tab">
            <ul>
              <li>Generate your SimBrief OFP</li>
              <li>When you reach SimBrief Briefing page, do check your flight plan (edit if necessary) and click <b>"Load in Acars"</b> button</li>
              <li>Acars will run and your flight will be loaded with full details (including your SimBrief OFP)</li>
            </ul>
          </div>
          <div class="tab-pane fade" id="pills-wosb" role="tabpanel" aria-labelledby="pills-wosb-tab">
            <ul>
              <li>Click on <b>"My Bids"</b> button</li>
              <li>Click on <b>"Load in Acars"</b> button</li>
              <li>Acars will run and your flight will be loaded with all available details</li>
            </ul>
          </div>
          <div class="tab-pane fade" id="pills-acars" role="tabpanel" aria-labelledby="pills-acars-tab">
            <ul>
              <li>Run acars</li>
              <li>Click <b>"Flight Search/Bid"</b> (A) icon</li>
              <li>Your personal flight will be listed under your bids</li>
              <li>Click on the <b>"Load"</b> (B) button (if generated your SimBrief OFP will be loaded too)</li>
            </ul>
          </div>
        </div>
      </div>
    </div>
    <div class="card mb-1">
      <div class="card-body p-1">
        <p>
          <b>(*)</b> If this is the case you can always use <b>JumpSeat Travel</b> module to transfer yourself between airports. 
          Please do check the flight and aircraft availabilities for your intended new location before going there. 
          We have no refund policy for JumpSeat ticket fees :)
        </p>
        <p>Please proceed to Starting / Reporting flights section ...</p>
      </div>
    </div>
  </div>
  <div class="col-md-4">
    <div class="card-body p-0">
      <img class="img-fluid rounded border border-dark" alt="" src="{{ public_asset('/image/acars/freeflight_01.png') }}"/>
    </div>
    <hr>
    <div class="card-body p-0">
      <img class="img-fluid rounded border border-dark" alt="" src="{{ public_asset('/image/acars/freeflight_02.png') }}"/>
    </div>
    <hr>
    <div class="card-body p-0">
      <img class="img-fluid rounded border border-dark" alt="" src="{{ public_asset('/image/acars/freeflight_03.png') }}"/>
    </div>
    <hr>
    <div class="card-body p-0">
      <img class="img-fluid rounded border border-dark" alt="" src="{{ public_asset('/image/acars/freeflight_04.png') }}"/>
    </div>
  </div>
</div>