@extends('toppilot::layouts.frontend')

@section('title', 'TopPilot')

@section('content')
<div class="row mb-5">
    <div class="card col-md-4 col-lg-4 bg-info text-white">
        <div class="card-header mt-3 mb-3">{{ config('toppilot.name') }} - By ParKho</div>
    </div>
</div>
<nav>
  <div class="nav nav-tabs" id="nav-tab" role="tablist">
    <button class="nav-link active mr-1" id="flighttime-tab" data-toggle="tab" data-target="#flighttime" type="button" role="tab" aria-controls="nav-flighttime" aria-selected="true">Top Pilots Best Flight Time</button>
    <button class="nav-link mr-1" id="distance-tab" data-toggle="tab" data-target="#distance" type="button" role="tab" aria-controls="nav-distance" aria-selected="false">Top Pilots Best Distance</button>
    <button class="nav-link mr-1" id="nav-landingrate-tab" data-toggle="tab" data-target="#landingrate" type="button" role="tab" aria-controls="nav-landingrate" aria-selected="false">Top Pilots Best Landing Rate</button>
    <button class="nav-link mr-1" id="nav-bestrevenue-tab" data-toggle="tab" data-target="#bestrevenue" type="button" role="tab" aria-controls="nav-bestrevenue" aria-selected="false">Top Pilots Best Revenue</button>
  </div>
</nav>
<div class="tab-content" id="nav-tabContent">
    <div class="tab-pane fade show active" id="flighttime" role="tabpanel" aria-labelledby="flighttime-tab">
        <div class="row">
            <div class="card col-md-6 col-lg-6">
                <div class="card-header mt-3 mb-3">Today - {{ $DayName }}, {{ $Month }} {{ $Day }}, {{ $Year }}</div>
                <div class="card-body">

                                @if($resultftDay->isEmpty())

                                    <h4 class="text-center">No Records Found</h4>

                                @else
                                    @foreach($resultftDay as $res)
                                    <table class="table mt-3">
                                        <thead>
                                            <tr>

                                                    <th>Rank</th>
                                                    <th>Pilot ID</th>
                                                    <th>Name</th>
                                                    <th>Current Location</th>
                                                    <th>Flight Time</th>

                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr>
                                                <td>{{ $loop->iteration }}</td>
                                                <td><a href="{{ route('frontend.users.show.public', [$res->user->id]) }}">{{$res->user->ident}}</a></td>
                                                <td>{{ $res->user->name_private }}</td>
                                                <td><a  href="{{ route('frontend.airports.show', [$res->user->curr_airport_id]) }}">{{ $res->user->curr_airport_id }}</a></td>
                                                <td class="text-success">@minutestotime($res->totaltime)</td>
                                            </tr>
                                        </tbody>
                                    </table>
                                    @endforeach
                                @endif

                </div>
            </div>
            <div class="card col-md-6 col-lg-6">
                <div class="card-header mt-3 mb-3">Week {{ $Week }} of {{ $Month }}, {{ $Year }}</div>
                <div class="card-body">
                    <table class="table mt-3">
                        <thead>
                            <tr>
                                <th>Rank</th>
                                <th>Pilot ID</th>
                                <th>Name</th>
                                <th>Current Location</th>
                                <th>Flight Time</th>
                            </tr>
                        </thead>
                        <tbody>
                            @if($resultftWeek->isEmpty())

                                    <h4 class="text-center">No Records Found</h4>

                            @else
                                @foreach($resultftWeek as $res)
                                    <tr>
                                        <td>{{ $loop->iteration }}</td>
                                        <td><a href="{{ route('frontend.users.show.public', [$res->user->id]) }}">{{$res->user->ident}}</a></td>
                                        <td>{{ $res->user->name_private }}</td>
                                        <td><a  href="{{ route('frontend.airports.show', [$res->user->curr_airport_id]) }}">{{ $res->user->curr_airport_id }}</a></td>
                                        <td class="text-success">@minutestotime($res->totaltime)</td>
                                    </tr>
                                @endforeach
                            @endif
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="card col-md-6 col-lg-6">
                <div class="card-header mt-3 mb-3">In {{ $Month }}, {{ $Year }}</div>
                <div class="card-body">
                    <table class="table mt-3">
                        <thead>
                            <tr>
                                <th>Rank</th>
                                <th>Pilot ID</th>
                                <th>Name</th>
                                <th>Current Location</th>
                                <th>Flight Time</th>
                            </tr>
                        </thead>
                        <tbody>
                            @if($resultftMonth->isEmpty())

                                    <h4 class="text-center">No Records Found</h4>

                            @else
                                @foreach($resultftMonth as $res)
                                    <tr>
                                        <td>{{ $loop->iteration }}</td>
                                        <td><a href="{{ route('frontend.users.show.public', [$res->user->id]) }}">{{$res->user->ident}}</a></td>
                                        <td>{{ $res->user->name_private }}</td>
                                        <td><a  href="{{ route('frontend.airports.show', [$res->user->curr_airport_id]) }}">{{ $res->user->curr_airport_id }}</a></td>
                                        <td class="text-success">@minutestotime($res->totaltime)</td>
                                    </tr>
                                @endforeach
                            @endif
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="card col-md-6 col-lg-6">
                <div class="card-header mt-3 mb-3">In Year {{ $Year }}</div>
                <div class="card-body">
                    <table class="table mt-3">
                        <thead>
                            <tr>
                                <th>Rank</th>
                                <th>Pilot ID</th>
                                <th>Name</th>
                                <th>Current Location</th>
                                <th>Flight Time</th>
                            </tr>
                            @if($resultftYear->isEmpty())

                                    <h4 class="text-center">No Records Found</h4>

                            @else
                                @foreach($resultftYear as $res)
                                    <tr>
                                        <td>{{ $loop->iteration }}</td>
                                        <td><a href="{{ route('frontend.users.show.public', [$res->user->id]) }}">{{$res->user->ident}}</a></td>
                                        <td>{{ $res->user->name_private }}</td>
                                        <td><a  href="{{ route('frontend.airports.show', [$res->user->curr_airport_id]) }}">{{ $res->user->curr_airport_id }}</a></td>
                                        <td class="text-success">@minutestotime($res->totaltime)</td>
                                    </tr>
                                @endforeach
                            @endif

                        </thead>
                        <tbody>

                        </tbody>
                    </table>
                </div>
            </div>
            <div class="card col-md-12 col-lg-12">
                <div class="card-header mt-3 mb-3">In Year {{ $LastYear }}</div>
                <div class="card-body">
                    <table class="table mt-3">
                        <thead>
                            <tr>
                                <th>Rank</th>
                                <th>Pilot ID</th>
                                <th>Name</th>
                                <th>Current Location</th>
                                <th>Flight Time</th>
                            </tr>
                            @if($resultftLastYear->isEmpty())

                                    <h4 class="text-center">No Records Found</h4>

                            @else
                                @foreach($resultftLastYear as $res)
                                    <tr>
                                        <td>{{ $loop->iteration }}</td>
                                        <td><a href="{{ route('frontend.users.show.public', [$res->user->id]) }}">{{$res->user->ident}}</a></td>
                                        <td>{{ $res->user->name_private }}</td>
                                        <td><a  href="{{ route('frontend.airports.show', [$res->user->curr_airport_id]) }}">{{ $res->user->curr_airport_id }}</a></td>
                                        <td class="text-success">@minutestotime($res->totaltime)</td>
                                    </tr>
                                @endforeach
                            @endif

                        </thead>
                        <tbody>

                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <div class="tab-pane fade show" id="distance" role="tabpanel" aria-labelledby="distance tab-tab">
        <div class="row">
            <div class="card col-md-6 col-lg-6">
                <div class="card-header mt-3 mb-3">Today - {{ $DayName }}, {{ $Month }} {{ $Day }}, {{ $Year }}</div>
                <div class="card-body">
                    @if($resultdDay->isEmpty())

                            <h4 class="text-center">No Records Found</h4>

                    @else
                        @foreach($resultdDay as $res)
                        <table class="table mt-3">
                            <thead>
                                <tr>
                                    <th>Rank</th>
                                    <th>Pilot ID</th>
                                    <th>Name</th>
                                    <th>Current Location</th>
                                    <th>Distance</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>{{ $loop->iteration }}</td>
                                    <td><a href="{{ route('frontend.users.show.public', [$res->user->id]) }}">{{$res->user->ident}}</a></td>
                                    <td>{{ $res->user->name_private }}</td>
                                    <td><a  href="{{ route('frontend.airports.show', [$res->user->curr_airport_id]) }}">{{ $res->user->curr_airport_id }}</a></td>
                                    <td class="text-success">{{ floor($res->totaldistance) }} NM</td>
                                </tr>
                            </tbody>
                        </table>
                        @endforeach
                    @endif
                </div>
            </div>
            <div class="card col-md-6 col-lg-6">
                <div class="card-header mt-3 mb-3">Week {{ $Week }} of {{ $Month }}, {{ $Year }}</div>
                <div class="card-body">
                    @if($resultdWeek->isEmpty())

                            <h4 class="text-center">No Records Found</h4>

                    @else
                        @foreach($resultdWeek as $res)
                        <table class="table mt-3">
                            <thead>
                                <tr>
                                    <th>Rank</th>
                                    <th>Pilot ID</th>
                                    <th>Name</th>
                                    <th>Current Location</th>
                                    <th>Distance</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>{{ $loop->iteration }}</td>
                                    <td><a href="{{ route('frontend.users.show.public', [$res->user->id]) }}">{{$res->user->ident}}</a></td>
                                    <td>{{ $res->user->name_private }}</td>
                                    <td><a  href="{{ route('frontend.airports.show', [$res->user->curr_airport_id]) }}">{{ $res->user->curr_airport_id }}</a></td>
                                    <td class="text-success">{{ floor($res->totaldistance) }} NM</td>
                                </tr>
                            </tbody>
                        </table>
                        @endforeach
                    @endif
                </div>
            </div>
            <div class="card col-md-6 col-lg-6">
                <div class="card-header mt-3 mb-3">In {{ $Month }}, {{ $Year }}</div>
                <div class="card-body">
                    @if($resultdMonth->isEmpty())

                            <h4 class="text-center">No Records Found</h4>

                    @else
                        @foreach($resultdMonth as $res)
                        <table class="table mt-3">
                            <thead>
                                <tr>
                                    <th>Rank</th>
                                    <th>Pilot ID</th>
                                    <th>Name</th>
                                    <th>Current Location</th>
                                    <th>Flight Time</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>{{ $loop->iteration }}</td>
                                    <td><a href="{{ route('frontend.users.show.public', [$res->user->id]) }}">{{$res->user->ident}}</a></td>
                                    <td>{{ $res->user->name_private }}</td>
                                    <td><a  href="{{ route('frontend.airports.show', [$res->user->curr_airport_id]) }}">{{ $res->user->curr_airport_id }}</a></td>
                                    <td class="text-success">{{ floor($res->totaldistance) }} NM</td>
                                </tr>
                            </tbody>
                        </table>
                        @endforeach
                    @endif
                </div>
            </div>
            <div class="card col-md-6 col-lg-6">
                <div class="card-header mt-3 mb-3">In Year {{ $Year }}</div>
                <div class="card-body">
                    @if($resultdYear->isEmpty())

                            <h4 class="text-center">No Records Found</h4>

                    @else
                        @foreach($resultdYear as $res)
                        <table class="table mt-3">
                            <thead>
                                <tr>
                                    <th>Rank</th>
                                    <th>Pilot ID</th>
                                    <th>Name</th>
                                    <th>Current Location</th>
                                    <th>Distance</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>{{ $loop->iteration }}</td>
                                    <td><a href="{{ route('frontend.users.show.public', [$res->user->id]) }}">{{$res->user->ident}}</a></td>
                                    <td>{{ $res->user->name_private }}</td>
                                    <td><a  href="{{ route('frontend.airports.show', [$res->user->curr_airport_id]) }}">{{ $res->user->curr_airport_id }}</a></td>
                                    <td class="text-success">{{ floor($res->totaldistance) }} NM</td>
                                </tr>
                            </tbody>
                        </table>
                        @endforeach
                    @endif
                </div>
            </div>
            <div class="card col-md-12 col-lg-12">
                <div class="card-header mt-3 mb-3">In Year {{ $LastYear }}</div>
                <div class="card-body">
                    @if($resultdLastYear->isEmpty())

                            <h4 class="text-center">No Records Found</h4>

                    @else
                        @foreach($resultdLastYear as $res)
                        <table class="table mt-3">
                            <thead>
                                <tr>
                                    <th>Rank</th>
                                    <th>Pilot ID</th>
                                    <th>Name</th>
                                    <th>Current Location</th>
                                    <th>Flight Time</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>{{ $loop->iteration }}</td>
                                    <td><a href="{{ route('frontend.users.show.public', [$res->user->id]) }}">{{$res->user->ident}}</a></td>
                                    <td>{{ $res->user->name_private }}</td>
                                    <td><a  href="{{ route('frontend.airports.show', [$res->user->curr_airport_id]) }}">{{ $res->user->curr_airport_id }}</a></td>
                                    <td class="text-success">{{ floor($res->totaldistance) }} NM</td>
                                </tr>
                            </tbody>
                        </table>
                        @endforeach
                    @endif
                </div>
            </div>
        </div>
    </div>
    <div class="tab-pane fade show" id="landingrate" role="tabpanel" aria-labelledby="landingrate tab-tab">
        <div class="row">
            <div class="card col-md-6 col-lg-6">
                <div class="card-header mt-3 mb-3">Today - {{ $DayName }}, {{ $Month }} {{ $Day }}, {{ $Year }}</div>
                <div class="card-body">
                    @if($resultlrDay->isEmpty())

                            <h4 class="text-center">No Records Found</h4>

                    @else
                        @foreach($resultlrDay as $res)
                        <table class="table mt-3">
                            <thead>
                                <tr>
                                    <th>Rank</th>
                                    <th>Pilot ID</th>
                                    <th>Name</th>
                                    <th>Current Location</th>
                                    <th>Landing Rate</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>{{ $loop->iteration }}</td>
                                    <td><a href="{{ route('frontend.users.show.public', [$res->user->id]) }}">{{$res->user->ident}}</a></td>
                                    <td>{{ $res->user->name_private }}</td>
                                    <td><a  href="{{ route('frontend.airports.show', [$res->user->curr_airport_id]) }}">{{ $res->user->curr_airport_id }}</a></td>
                                    <td class="text-success">{{ floor($res->landing_rate) }} fps</td>
                                </tr>
                            </tbody>
                        </table>
                        @endforeach
                    @endif
                </div>
            </div>
            <div class="card col-md-6 col-lg-6">
                <div class="card-header mt-3 mb-3">Week {{ $Week }} of {{ $Month }}, {{ $Year }}</div>
                <div class="card-body">
                    @if($resultlrWeek->isEmpty())

                            <h4 class="text-center">No Records Found</h4>

                    @else
                        @foreach($resultlrWeek as $res)
                        <table class="table mt-3">
                            <thead>
                                <tr>
                                    <th>Rank</th>
                                    <th>Pilot ID</th>
                                    <th>Name</th>
                                    <th>Current Location</th>
                                    <th>Landing Rate</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>{{ $loop->iteration }}</td>
                                    <td><a href="{{ route('frontend.users.show.public', [$res->user->id]) }}">{{$res->user->ident}}</a></td>
                                    <td>{{ $res->user->name_private }}</td>
                                    <td><a  href="{{ route('frontend.airports.show', [$res->user->curr_airport_id]) }}">{{ $res->user->curr_airport_id }}</a></td>
                                    <td class="text-success">{{ floor($res->landing_rate) }} fps</td>
                                </tr>
                            </tbody>
                        </table>
                        @endforeach
                    @endif
                </div>
            </div>
            <div class="card col-md-6 col-lg-6">
                <div class="card-header mt-3 mb-3">In {{ $Month }}, {{ $Year }}</div>
                <div class="card-body">
                    @if($resultlrMonth->isEmpty())

                        <h4 class="text-center">No Records Found</h4>

                    @else
                        @foreach($resultlrMonth as $res)
                        <table class="table mt-3">
                            <thead>
                                <tr>
                                    <th>Rank</th>
                                    <th>Pilot ID</th>
                                    <th>Name</th>
                                    <th>Current Location</th>
                                    <th>Landing Rate</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>{{ $loop->iteration }}</td>
                                    <td><a href="{{ route('frontend.users.show.public', [$res->user->id]) }}">{{$res->user->ident}}</a></td>
                                    <td>{{ $res->user->name_private }}</td>
                                    <td><a  href="{{ route('frontend.airports.show', [$res->user->curr_airport_id]) }}">{{ $res->user->curr_airport_id }}</a></td>
                                    <td class="text-success">{{ floor($res->landing_rate) }} fps</td>
                                </tr>
                            </tbody>
                        </table>
                        @endforeach
                    @endif
                </div>
            </div>
            <div class="card col-md-6 col-lg-6">
                <div class="card-header mt-3 mb-3">This Year {{ $Year }}</div>
                <div class="card-body">
                    @if($resultlrYear->isEmpty())

                        <h4 class="text-center">No Records Found</h4>

                    @else
                        @foreach($resultlrYear as $res)
                        <table class="table mt-3">
                            <thead>
                                <tr>
                                    <th>Rank</th>
                                    <th>Pilot ID</th>
                                    <th>Name</th>
                                    <th>Current Location</th>
                                    <th>Landing Rate</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>{{ $loop->iteration }}</td>
                                    <td><a href="{{ route('frontend.users.show.public', [$res->user->id]) }}">{{$res->user->ident}}</a></td>
                                    <td>{{ $res->user->name_private }}</td>
                                    <td><a  href="{{ route('frontend.airports.show', [$res->user->curr_airport_id]) }}">{{ $res->user->curr_airport_id }}</a></td>
                                    <td class="text-success">{{ floor($res->landing_rate) }} fps</td>
                                </tr>
                            </tbody>
                        </table>
                        @endforeach
                    @endif
                </div>
            </div>
            <div class="card col-md-12 col-lg-12">
                <div class="card-header mt-3 mb-3">In Year {{ $LastYear }}</div>
                <div class="card-body">
                    @if($resultlrLastYear->isEmpty())

                        <h4 class="text-center">No Records Found</h4>

                    @else
                        @foreach($resultlrLastYear as $res)
                        <table class="table mt-3">
                            <thead>
                                <tr>
                                    <th>Rank</th>
                                    <th>Pilot ID</th>
                                    <th>Name</th>
                                    <th>Current Location</th>
                                    <th>Landing Rate</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>{{ $loop->iteration }}</td>
                                    <td><a href="{{ route('frontend.users.show.public', [$res->user->id]) }}">{{$res->user->ident}}</a></td>
                                    <td>{{ $res->user->name_private }}</td>
                                    <td><a  href="{{ route('frontend.airports.show', [$res->user->curr_airport_id]) }}">{{ $res->user->curr_airport_id }}</a></td>
                                    <td class="text-success">{{ floor($res->landing_rate) }} fps</td>
                                </tr>
                            </tbody>
                        </table>
                        @endforeach
                    @endif
                </div>
            </div>
        </div>
    </div>
    <div class="tab-pane fade show" id="bestrevenue" role="tabpanel" aria-labelledby="bestrevenue tab-tab">
        <div class="row">
            <div class="card col-md-6 col-lg-6">
                <div class="card-header mt-3 mb-3">Today - {{ $DayName }}, {{ $Month }} {{ $Day }}, {{ $Year }}</div>
                <div class="card-body">
                    @if(!$resultbrDay)

                        <h4 class="text-center">No Records Found</h4>

                    @else
                        @foreach($resultbrDay as $res)
                        <table class="table mt-3">
                            <thead>
                                <tr>
                                    <th>Rank</th>
                                    <th>Pilot ID</th>
                                    <th>Name</th>
                                    <th>Current Location</th>
                                    <th>Best Revenue</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>{{ $loop->iteration }}</td>
                                    <td><a href="{{ route('frontend.users.show.public', [$res['user_id']]) }}">{{ $res['ident'] }}</a></td>
                                    <td>{{ $res['name'] }}</td>
                                    <td><a  href="{{ route('frontend.airports.show', [$res['curr_airport_id']]) }}">{{ $res['curr_airport_id'] }}</a></td>
                                    <td class="text-success">{{ money($res['total_balance'], $curr_unit) }}</td>
                                </tr>
                            </tbody>
                        </table>
                        @endforeach
                    @endif
                </div>
            </div>
            <div class="card col-md-6 col-lg-6">
                <div class="card-header mt-3 mb-3">Week {{ $Week }} of {{ $Month }}, {{ $Year }}</div>
                <div class="card-body">
                    @if(!$resultbrWeek)

                        <h4 class="text-center">No Records Found</h4>

                    @else
                        @foreach($resultbrWeek as $res)
                        <table class="table mt-3">
                            <thead>
                                <tr>
                                    <th>Rank</th>
                                    <th>Pilot ID</th>
                                    <th>Name</th>
                                    <th>Current Location</th>
                                    <th>Best Revenue</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>{{ $loop->iteration }}</td>
                                    <td><a href="{{ route('frontend.users.show.public', [$res['user_id']]) }}">{{ $res['ident'] }}</a></td>
                                    <td>{{ $res['name'] }}</td>
                                    <td><a  href="{{ route('frontend.airports.show', [$res['curr_airport_id']]) }}">{{ $res['curr_airport_id'] }}</a></td>
                                    <td class="text-success">{{ money($res['total_balance'], $curr_unit) }}</td>
                                </tr>
                            </tbody>
                        </table>
                        @endforeach
                    @endif
                </div>
            </div>
            <div class="card col-md-6 col-lg-6">
                <div class="card-header mt-3 mb-3">In {{ $Month }}, {{ $Year }}</div>
                <div class="card-body">
                    @if(!$resultbrMonth)

                        <h4 class="text-center">No Records Found</h4>

                    @else
                        @foreach($resultbrMonth as $res)
                        <table class="table mt-3">
                            <thead>
                                <tr>
                                    <th>Rank</th>
                                    <th>Pilot ID</th>
                                    <th>Name</th>
                                    <th>Current Location</th>
                                    <th>Best Revenue</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>{{ $loop->iteration }}</td>
                                    <td><a href="{{ route('frontend.users.show.public', [$res['user_id']]) }}">{{ $res['ident'] }}</a></td>
                                    <td>{{ $res['name'] }}</td>
                                    <td><a  href="{{ route('frontend.airports.show', [$res['curr_airport_id']]) }}">{{ $res['curr_airport_id'] }}</a></td>
                                    <td class="text-success">{{ money($res['total_balance'], $curr_unit) }}</td>
                                </tr>
                                </tbody>
                        </table>
                        @endforeach
                    @endif
                </div>
            </div>
            <div class="card col-md-6 col-lg-6">
                <div class="card-header mt-3 mb-3">This Year - {{ $Year }}</div>
                <div class="card-body">
                    @if(!$resultbrYear)

                        <h4 class="text-center">No Records Found</h4>

                    @else
                        @foreach($resultbrYear as $res)
                        <table class="table mt-3">
                            <thead>
                                <tr>
                                    <th>Rank</th>
                                    <th>Pilot ID</th>
                                    <th>Name</th>
                                    <th>Current Location</th>
                                    <th>Best Revenue</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>{{ $loop->iteration }}</td>
                                    <td><a href="{{ route('frontend.users.show.public', [$res['user_id']]) }}">{{ $res['ident'] }}</a></td>
                                    <td>{{ $res['name'] }}</td>
                                    <td><a  href="{{ route('frontend.airports.show', [$res['curr_airport_id']]) }}">{{ $res['curr_airport_id'] }}</a></td>
                                    <td class="text-success">{{ money($res['total_balance'], $curr_unit) }}</td>
                                </tr>
                            </tbody>
                        </table>
                        @endforeach
                    @endif
                </div>
            </div>
            <div class="card col-md-12 col-lg-12">
                <div class="card-header mt-3 mb-3">In {{ $LastYear }}</div>
                <div class="card-body">
                    @if(!$resultbrLastYear)

                        <h4 class="text-center">No Records Found</h4>

                    @else
                        @foreach($resultbrLastYear as $res)
                        <table class="table mt-3">
                            <thead>
                                <tr>
                                    <th>Rank</th>
                                    <th>Pilot ID</th>
                                    <th>Name</th>
                                    <th>Current Location</th>
                                    <th>Best Revenue</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>{{ $loop->iteration }}</td>
                                    <td><a href="{{ route('frontend.users.show.public', [$res['user_id']]) }}">{{ $res['ident'] }}</a></td>
                                    <td>{{ $res['name'] }}</td>
                                    <td><a  href="{{ route('frontend.airports.show', [$res['curr_airport_id']]) }}">{{ $res['curr_airport_id'] }}</a></td>
                                    <td class="text-success">{{ money($res['total_balance'], $curr_unit) }}</td>
                                </tr>
                            </tbody>
                        </table>
                        @endforeach
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
