<?php

namespace Modules\Weather\Http\Controllers\Frontend;

use App\Contracts\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;
/**
 * Class $CLASS$
 * @package
 */
class IndexController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @param Request $request
     *
     * @return mixed
     */
    public function index(Request $request)
    {
        return view('weather::index');
    }

    public function getMetar(Request $request)
    {
        $request->validate([
            'icao' => 'required|string|max:4'
        ]);

        $icao = strtoupper($request->input('icao'));

        $url = 'https://aviationweather.gov/api/data/metar?ids='.$icao.'&format=xml';

        $response = Http::get($url);
        $xml = simplexml_load_string($response->body());

        if (!$xml || empty($xml->data->METAR)) {
            return response()->json(['error' => 'No METAR data found'], 404);
        }

        $metarData = [
            'raw_text' => (string) $xml->data->METAR->raw_text,
            'altimeter' => (float) $xml->data->METAR->altim_in_hg,
            'temperature' => (float) $xml->data->METAR->temp_c,
            'dewpoint' => (float) $xml->data->METAR->dewpoint_c,
            'wind_direction' => (int) $xml->data->METAR->wind_dir_degrees,
            'wind_speed' => (int) $xml->data->METAR->wind_speed_kt,
            'visibility' => (float) $xml->data->METAR->visibility_statute_mi,
            'flight_rules' => (string) $xml->data->METAR->flight_category,
            'observation_time' => (string) $xml->data->METAR->observation_time
        ];

        return view('weather::index', ['metarData' => $metarData]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @param Request $request
     *
     * @return mixed
     */
    public function create(Request $request)
    {
        return view('weather::create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param Request $request
     *
     * @return mixed
     */
    public function store(Request $request)
    {
    }

    /**
     * Show the specified resource.
     *
     * @param Request $request
     *
     * @return mixed
     */
    public function show(Request $request)
    {
        return view('weather::show');
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param Request $request
     *
     * @return mixed
     */
    public function edit(Request $request)
    {
        return view('weather::edit');
    }

    /**
     * Update the specified resource in storage.
     *
     * @param Request $request
     */
    public function update(Request $request)
    {
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param Request $request
     */
    public function destroy(Request $request)
    {
    }
}
