@extends('weather::layouts.frontend')

@section('title', 'Weather')

@section('content')
<h2 class="mb-4">Aviation Weather - METAR Data</h2>
<form method="POST" action="{{ url('/weather/metar') }}">
    @csrf
    <div class="mb-3">
        <label for="icao" class="form-label">Enter ICAO Code:</label>
        <input type="text" id="icao" name="icao" class="form-control" maxlength="4" required>
    </div>
    <button type="submit" class="btn btn-primary">Get METAR</button>
</form>

@if(isset($metarData))
    <div class="mt-4 p-3 border rounded bg-light">
        <h4>METAR Data for {{ request('icao') }}</h4>
        <p><strong>Raw METAR:</strong> {{ $metarData['raw_text'] }}</p>
        <p><strong>Altimeter:</strong> {{ $metarData['altimeter'] }} inHg</p>
        <p><strong>Temperature:</strong> {{ $metarData['temperature'] }}°C</p>
        <p><strong>Dew Point:</strong> {{ $metarData['dewpoint'] }}°C</p>
        <p><strong>Wind:</strong> {{ $metarData['wind_direction'] }}° at {{ $metarData['wind_speed'] }} knots</p>
        <p><strong>Visibility:</strong> {{ $metarData['visibility'] }} miles</p>
        <p><strong>Flight Rules:</strong> {{ $metarData['flight_rules'] }}</p>
        <p><strong>Observation Time:</strong> {{ $metarData['observation_time'] }}</p>
    </div>
@endif
@endsection
