<?php

use App\Contracts\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

class AddShopAirlineIdToSettings extends Migration
{
    public function up()
    {
        if (Schema::hasTable('aadv_miles_settings') && !Schema::hasColumn('aadv_miles_settings', 'shop_airline_id')) {
            Schema::table('aadv_miles_settings', function (Blueprint $table) {
                $table->unsignedInteger('shop_airline_id')->nullable()->after('airport_miles');
            });

            // Set initial value to the lowest Airline ID or 1
            $min_airline = (int) (DB::table('airlines')->min('id') ?: 1);
            DB::table('aadv_miles_settings')->updateOrInsert(['id' => 1], ['shop_airline_id' => $min_airline]);
        }
    }

    public function down()
    {
        if (Schema::hasTable('aadv_miles_settings') && Schema::hasColumn('aadv_miles_settings', 'shop_airline_id')) {
            Schema::table('aadv_miles_settings', function (Blueprint $table) {
                $table->dropColumn('shop_airline_id');
            });
        }
    }
}

