<?php

namespace Modules\AAdvantageMiles\Http\Middleware;

use Closure;
use Illuminate\Support\Facades\Auth;
use Modules\AAdvantageMiles\Models\MilesSettings;
use Modules\AAdvantageMiles\Services\MilesLedger;

class DailyVisitMiddleware
{
    public function handle($request, Closure $next)
    {
        $user = Auth::user();
        if ($user) {
            $settings = MilesSettings::first();
            if ($settings && $settings->enabled && $settings->daily_visit_enabled && $settings->daily_visit_miles > 0) {
                $key = sprintf('daily_visit:%d:%s', $user->id, now()->toDateString());
                app(MilesLedger::class)->add(
                    user_id: $user->id,
                    miles: $settings->daily_visit_miles,
                    source: 'daily_visit',
                    event_id: now()->toDateString(),
                    note: 'Daily Login',
                    meta: null,
                    issued_by: null,
                    unique_key: $key
                );
            }
        }
        return $next($request);
    }
}

