<?php

namespace Modules\AAdvantageMiles\Models;

use Illuminate\Database\Eloquent\Model;

class MilesSettings extends Model
{
    protected $table = 'aadv_miles_settings';

    public $timestamps = false;

    protected $fillable = [
        'id', 'enabled',
        'daily_visit_enabled', 'daily_visit_miles',
        'miles_per_min_enabled', 'miles_per_min',
        'smooth_enabled', 'smooth_limit', 'smooth_miles',
        'bad_enabled', 'bad_limit', 'bad_miles',
        'score_bonus_enabled', 'score_max',
        'airport_miles',
        'shop_airline_id',
        'enforce_rank_bids',
    ];

    protected $casts = [
        'enabled' => 'boolean',
        'daily_visit_enabled' => 'boolean',
        'miles_per_min_enabled' => 'boolean',
        'smooth_enabled' => 'boolean',
        'bad_enabled' => 'boolean',
        'score_bonus_enabled' => 'boolean',
        'airport_miles' => 'array',
        'shop_airline_id' => 'integer',
        'enforce_rank_bids' => 'boolean',
    ];
}

