<?php

namespace Modules\AAdvantageMiles\Providers;

use Illuminate\Foundation\Support\Providers\RouteServiceProvider as ServiceProvider;
use Illuminate\Support\Facades\Route;

class RouteServiceProvider extends ServiceProvider
{
    public function boot()
    {
        parent::boot();

        // Frontend routes
        Route::group([
            'as' => 'AAMiles.',
            'prefix' => '',
            'middleware' => ['web', 'auth', 'aamiles.daily'],
            'namespace' => 'Modules\\AAdvantageMiles\\Http\\Controllers',
        ], function () {
            // Primary paths
            Route::get('aadvantage-miles', 'FrontendController@myMiles')->name('my_miles');
            Route::get('aadvantage-miles/leaderboard', 'FrontendController@leaderboard')->name('leaderboard');
            // Aliases for theme/menu compatibility
            Route::get('aadvantagemiles', 'FrontendController@myMiles')->name('aadvantagemiles');
            Route::get('aadvantagemiles/leaderboard', 'FrontendController@leaderboard')->name('aadvantagemiles.leaderboard');
            Route::get('aamiles', 'FrontendController@myMiles')->name('aamiles');
            Route::get('aadvantage-miles/shop', 'ShopController@index')->name('shop');
            Route::post('aadvantage-miles/shop/buy/{productId}', 'ShopController@buy')->name('shop.buy');
            Route::get('aadvantage-miles/purchases', 'ShopController@purchases')->name('purchases');
            Route::post('aadvantage-miles/purchases/{orderId}/delete', 'ShopController@deletePurchase')->name('purchases.delete');
            // Aliases for American theme menu routes
            Route::get('shop', 'ShopController@index')->name('creationcrew.shop');
            Route::get('shop/purchases', 'ShopController@purchases')->name('creationcrew.shop.purchases');
            // Flight Pass direct-bid
            Route::post('aamiles/pass/bid', 'FrontendController@bidPass')->name('pass.bid');

            Route::get('aamiles/leaderboard', 'FrontendController@leaderboard')->name('aamiles.leaderboard');
        });

        // Admin routes
        Route::group([
            'as' => 'AAMiles.',
            'prefix' => 'admin',
            'middleware' => ['web', 'auth', 'ability:admin,admin-access'],
            'namespace' => 'Modules\\AAdvantageMiles\\Http\\Controllers',
        ], function () {
            // Canonical admin path used by our menu and form action
            Route::get('aamiles', 'AdminController@index')->name('admin');
            Route::post('aamiles/settings', 'AdminController@save')->name('admin.save');

            // Aliases so "View Admin Module" and other links work
            // Shop admin
            Route::get('aamiles/shop', 'AdminShopController@index')->name('admin.shop');
            Route::post('aamiles/shop/categories', 'AdminShopController@saveCategory')->name('admin.shop.categories.save');
            Route::post('aamiles/shop/products', 'AdminShopController@saveProduct')->name('admin.shop.products.save');
            Route::post('aamiles/shop/products/delete', 'AdminShopController@deleteProduct')->name('admin.shop.products.delete');
            // AJAX endpoint for Select2 (kept for compatibility)
            Route::get('aamiles/shop/flight-search', 'AdminShopController@flightSearch')->name('admin.shop.flight_search');

            // Manage pilot miles (admin adjustments)
            Route::get('aamiles/manage', 'AdminController@manage')->name('admin.manage');
            Route::post('aamiles/manage/adjust', 'AdminController@adjust')->name('admin.manage.adjust');

            Route::get('aadvantagemiles', 'AdminController@index');
            Route::post('aadvantagemiles/settings', 'AdminController@save');
            Route::get('aadvantage-miles', 'AdminController@index');
            Route::post('aadvantage-miles/settings', 'AdminController@save');
        });
    }
}

