@extends('admin.app')
@section('title', 'Pick a Flight')
@section('content')
<div class="aam-admin-pad">
  <h4>Select a Flight (Airline ID: {{ $airline_id }})</h4>
  <form method="get" class="form-inline mb-3">
    <input type="hidden" name="airline_id" value="{{ $airline_id }}" />
    <input class="form-control" style="max-width:240px" name="q" value="{{ $q }}" placeholder="Search number or airport">
    <button class="btn btn-primary" type="submit">Search</button>
    <a class="btn btn-secondary" href="{{ route('AAMiles.admin.shop') }}">Back</a>
  </form>
  <div class="content table-responsive table-full-width">
    <table class="table table-hover">
      <thead><tr><th>Flight</th><th>Route</th><th></th></tr></thead>
      <tbody>
      @foreach($flights as $f)
        <tr>
          <td>{{ optional($f->airline)->icao }}{{ $f->flight_number }}</td>
          <td>{{ $f->dpt_airport_id }} → {{ $f->arr_airport_id }}</td>
          <td><a class="btn btn-sm btn-primary" href="{{ route('AAMiles.admin.shop', ['flight_id' => $f->id]) }}">Use</a></td>
        </tr>
      @endforeach
      </tbody>
    </table>
  </div>
  {{ $flights->links() }}
</div>
@endsection

