@extends('admin.app')
@section('title', 'AAdvantage Shop Admin')
@section('css')
  <style>
    .aam-admin-pad{padding:16px}
    /* keep form controls within card width */
    .content textarea.form-control{max-width:100%}
    /* ensure Select2 dropdown overlays within admin cards */
    .select2-container{z-index: 9999 !important}
  </style>
@endsection
@section('scripts')
  <script>
    (function(){
      const SEED_AIRLINE_ID = {{ (int)($seed_airline_id ?? 1) }};
      const run = function(){
        const $sel = $('.aam_flight_select');
        // If admin bootstrap already initialized .select2 globally, destroy and re-init with our AJAX options
        if ($sel.hasClass('select2-hidden-accessible')) { try { $sel.select2('destroy'); } catch(e){} }
        $sel.select2({
          ajax: {
            url: BASE_URL + '/admin/aamiles/shop/flight-search',
            data: function (params) {
              return {
                q: params.term || '',
                page: params.page || 1,
                airline_id: SEED_AIRLINE_ID,
              };
            },
            delay: 150,
            dataType: 'json',
            cache: true,
            processResults: function (data) {
              try {
                const rows = Array.isArray(data?.results) ? data.results : (Array.isArray(data?.data) ? data.data : []);
                const results = rows.map(function (f) {
                  const icao = (f.airline && (f.airline.icao || f.airline.code)) ? (f.airline.icao || f.airline.code) : (f.al || '');
                  const dpt = f.dpt_airport_id || f.dep || '';
                  const arr = f.arr_airport_id || f.arr || '';
                  const num = f.flight_number || f.num || '';
                  const text = (icao + num + ' ' + dpt + ' \u2192 ' + arr).trim();
                  return { id: f.id, text: text };
                });
                const more = !!(data?.pagination?.more) || !!(data?.meta && data.meta.next_page !== null && data.meta.next_page !== undefined);
                return { results, pagination: { more } };
              } catch (e) {
                console.warn('ACC flight search parse error', e, data);
                return { results: [], pagination: { more: false } };
              }
            },
            transport: function (params, success, failure) {
              // Log errors to help diagnose immediately
              const req = $.ajax(params);
              req.then(success).fail(function(xhr){
                console.error('ACC flight search failed', xhr.status, xhr.responseText);
                failure(xhr);
              });
              return req;
            }
          },
          width: 'resolve',
          dropdownParent: $(document.body),
          placeholder: 'Select an ACC flight',
          minimumInputLength: 0,
          allowClear: true
        });
        // Seed the dropdown with first page so it never shows empty
        $.ajax({
          url: BASE_URL + '/admin/aamiles/shop/flight-search',
          dataType: 'json',
          data: { page: 1, airline_id: SEED_AIRLINE_ID },
          success: function(d){
            const rows = Array.isArray(d?.results) ? d.results : [];
            if (rows.length) {
              rows.forEach(function(r){
                if ($sel.find("option[value='"+r.id+"']").length === 0) {
                  $sel.append(new Option(r.text, r.id, false, false));
                }
              });
              $sel.trigger('change.select2');
            }
          },
          error: function(xhr){
            console.error('ACC seed fetch failed', xhr.status, xhr.responseText);
          }
        });


        // Preselect existing flight if editing
        @php($pref = optional($edit)->meta['flight_id'] ?? null)
        @if(!empty($pref))
        (async function(){
          try {
            const pref = "{{ optional($edit)->meta['flight_id'] ?? '' }}";
            if (pref) {
              const resp = await fetch(`${BASE_URL}/api/flights/${encodeURIComponent(pref)}`, {
                headers: { 'X-API-KEY': document.querySelector('meta[name="api-key"]').getAttribute('content') }
              });
              const json = await resp.json();
              const f = json && json.data;
              if (f) {
                const icao = (f.airline && f.airline.icao) ? f.airline.icao : '';
                const text = (icao + f.flight_number + ' ' + f.dpt_airport_id + ' \u2192 ' + f.arr_airport_id).trim();
                const opt = new Option(text, f.id, true, true);
                $sel.append(opt).trigger('change');
              }
            }
          } catch(e){}
        })();
        @endif
      };
      if (document.readyState === 'loading') {
        document.addEventListener('DOMContentLoaded', run);
      } else { run(); }
    })();
  </script>
@endsection
@section('content')
<div class="aam-admin-pad">
@if(session('success'))
  <div class="alert alert-success">{{ session('success') }}</div>
@endif
@if(session('error'))
  <div class="alert alert-danger">{{ session('error') }}</div>
@endif
@if($errors->any())
  <div class="alert alert-danger">
    <ul class="mb-0">
      @foreach($errors->all() as $e)<li>{{ $e }}</li>@endforeach
    </ul>
  </div>
@endif
<div class="row">
  <div class="col-sm-6">
    <div class="card border-blue-bottom">
      <div class="header"><h4 class="title">Categories</h4></div>
      <div class="content">
        @php($editCat = $editCat ?? ((isset($categories) && request()->query('edit_cat')) ? $categories->firstWhere('id', request()->query('edit_cat')) : null))

        <form method="post" action="{{ route('AAMiles.admin.shop.categories.save') }}" class="form-group">
          @csrf
          <input type="hidden" name="id" value="{{ optional($editCat ?? null)->id }}">
          <div class="row">
            <div class="form-group col-sm-8">
              <label>Name</label>
              <input class="form-control" name="name" value="{{ optional($editCat ?? null)->name }}" required>
            </div>
            <div class="form-group col-sm-2">
              <label>Sort</label>
              <input class="form-control" type="number" name="sort" value="{{ optional($editCat ?? null)->sort ?? 0 }}">
            </div>
            <div class="form-group col-sm-2 text-center">
              <br>
              <button class="btn btn-primary" type="submit">{{ !empty($editCat ?? null) ? 'Update' : 'Add' }}</button>
              @if(!empty($editCat ?? null))
                <a class="btn btn-secondary ml-2" href="{{ route('AAMiles.admin.shop') }}">Cancel</a>
              @endif
            </div>
          </div>
        </form>
        <div class="content table-responsive table-full-width">
          <table class="table table-hover">
            <thead><tr><th>Name</th><th>Sort</th><th>Active</th><th class="text-end">Actions</th></tr></thead>
            <tbody>
            @foreach(($categories ?? []) as $c)
              <tr>
                <td>{{ $c->name }}</td>
                <td>{{ $c->sort }}</td>
                <td>{{ $c->is_active? 'Yes':'No' }}</td>
                <td class="text-end">
                  <a class="btn btn-sm btn-outline-primary" href="{{ route('AAMiles.admin.shop', ['edit_cat' => $c->id]) }}"><i class="fas fa-edit me-1"></i>Edit</a>
                </td>
              </tr>
            @endforeach
            </tbody>
          </table>
        </div>
      </div>
    </div>
    <div class="card border-blue-bottom mt-3">
      <div class="header"><h4 class="title">Purchases Ledger</h4></div>
      <div class="content table-responsive table-full-width">
        <table class="table table-hover">
          <thead>
            <tr>
              <th>Date</th>
              <th>Pilot</th>
              <th>Product</th>
              <th class="text-end">Cost (Miles)</th>
            </tr>
          </thead>
          <tbody>
            @forelse(($orders ?? []) as $o)
              <tr>
                <td>{{ \Carbon\Carbon::parse($o->created_at)->format('Y-m-d H:i') }}</td>
                <td><a href="{{ route('admin.users.edit', [$o->user_id]) }}">{{ $o->user_name }}</a></td>
                <td>{{ $o->product_name }}</td>
                <td class="text-end">{{ number_format((int)($o->cost_miles ?? 0)) }}</td>
              </tr>
            @empty
              <tr><td colspan="4" class="text-center text-muted">No purchases yet</td></tr>
            @endforelse
          </tbody>
        </table>
        <div class="px-3 pb-3">
          {{ ($orders ?? null) ? $orders->links('admin.pagination.default') : '' }}
        </div>
      </div>
    </div>

  </div>
  <div class="col-sm-6">
    <div class="card border-blue-bottom">
      <div class="header d-flex align-items-center justify-content-between"><h4 class="title mb-0">Products</h4></div>
      <div class="content">
        <form method="post" action="{{ route('AAMiles.admin.shop.products.save') }}" class="form-group">
          @csrf
          <input type="hidden" name="id" value="{{ optional($edit)->id }}">
          <div class="row">
            <div class="form-group col-sm-6">
              <label>Name</label>
              <input class="form-control" name="name" value="{{ optional($edit)->name }}" required>
            </div>

                @if(!empty($acc_flights))
                  <script>
                    (function(){
                      const sel = document.getElementById('fp_flight_id');
                      if (sel && sel.options.length === 0) {
                        @foreach($acc_flights as $af)
                          sel.add(new Option("{{ optional($af->airline)->icao }}{{ $af->flight_number }} {{ $af->dpt_airport_id }} → {{ $af->arr_airport_id }}", "{{ $af->id }}"));
                        @endforeach
                      }
                    })();
                  </script>
                @endif

            <div class="form-group col-sm-6">
              <label>Category</label>
              <select name="category_id" class="form-control select2" required>
                @foreach(($categories ?? []) as $c)
                  <option value="{{ $c->id }}" {{ optional($edit)->category_id == $c->id ? 'selected' : '' }}>{{ $c->name }}</option>
                @endforeach
              </select>
            </div>
          </div>
          <div class="form-group">
            <label>Description (HTML allowed)</label>
            <textarea class="form-control" name="description" rows="3">{{ optional($edit)->description }}</textarea>
          </div>
          <div class="row">
            <div class="form-group col-sm-6">
              <label>Image URL</label>
              <input class="form-control" name="image_url" value="{{ optional($edit)->image_url }}">
            </div>
            <div class="form-group col-sm-3">
              <label>Cost (miles)</label>
              <input class="form-control" type="number" min="1" name="cost_miles" value="{{ optional($edit)->cost_miles }}" required>
            </div>
            <div class="form-group col-sm-3">
              <label>Sort</label>
              <input class="form-control" type="number" name="sort" value="{{ optional($edit)->sort ?? 0 }}">
            </div>
          </div>
          <div class="row">
            <div class="row">
              <div class="form-group col-sm-4">
                <div class="checkbox" style="margin-top:26px;">
                  <label>
                    <input type="checkbox" name="fp_enabled" id="fp_enabled" {{ (optional($edit)->meta['type'] ?? '') === 'flight_pass' ? 'checked' : '' }}> Flight Pass
                  </label>
                </div>
              </div>
              <div class="form-group col-sm-5">
                <label>Flight (ID or Number)</label>
                <input name="fp_flight_code" id="fp_flight_code" class="form-control" placeholder="e.g., 123 or paste Flight ID; airline filter is configurable in Settings" value="{{ old('fp_flight_code', optional($edit)->meta['flight_id'] ?? '') }}">
                <input type="hidden" name="fp_flight_id" value="{{ old('fp_flight_id', optional($edit)->meta['flight_id'] ?? '') }}">
                <small class="text-muted">No dropdown. Type the flight number (e.g., 123) or paste the Flight ID. We’ll resolve it in airline 15.</small>
              </div>
              <div class="form-group col-sm-3">
                <label>Aircraft ID</label>
                <input name="fp_aircraft_id" id="fp_aircraft_id" class="form-control" type="number" min="1" placeholder="e.g., 2056" value="{{ old('fp_aircraft_id', optional($edit)->meta['aircraft_id'] ?? '') }}">
                <small class="text-muted">Pre-set aircraft to tie the bid to.</small>
              </div>
            </div>

            <div class="form-group col-sm-4">
              <label>Stock limit</label>
              <input class="form-control" type="number" name="stock_limit" value="{{ optional($edit)->stock_limit }}" placeholder="blank = unlimited">
            </div>
            <div class="form-group col-sm-4">
              <label>Per-user limit</label>
              <input class="form-control" type="number" name="per_user_limit" value="{{ optional($edit)->per_user_limit }}" placeholder="blank = unlimited">
            </div>
            <div class="form-group col-sm-4">
              <div class="checkbox" style="margin-top:26px;">
                <label>
                  <input type="checkbox" name="is_active" id="is_active" {{ optional($edit)->is_active ? 'checked' : '' }}> Active
                </label>
              </div>
            </div>
          </div>
          <div class="row">
            <div class="col-sm-12 text-center">
              <button class="btn btn-primary" type="submit">{{ $edit ? 'Update Product' : 'Save Product' }}</button>
              @if($edit)
                <a class="btn btn-secondary ml-2" href="{{ route('AAMiles.admin.shop') }}">Cancel</a>
              @endif
            </div>
          </div>

        </form>
        <hr>
        <div class="content table-responsive table-full-width">
          <table class="table table-hover">
            <thead><tr><th>Name</th><th>Category</th><th>Cost</th><th>Active</th><th class="text-end">Actions</th></tr></thead>
            <tbody>
              @foreach(($products ?? []) as $p)
                <tr>
                  <td>{{ $p->name }}</td>
                  <td>{{ optional($categories->firstWhere('id', $p->category_id))->name }}</td>
                  <td>{{ $p->cost_miles }}</td>
                  <td>{{ $p->is_active? 'Yes':'No' }}</td>
                  <td class="text-end">
                    <a class="btn btn-sm btn-outline-primary" href="{{ route('AAMiles.admin.shop', ['edit' => $p->id]) }}"><i class="fas fa-edit me-1"></i>Edit</a>
                    <form method="post" action="{{ url('admin/aamiles/shop/products/delete') }}" class="d-inline" onsubmit="return confirm('Delete product {{ $p->name }}?');">
                      @csrf
                      <input type="hidden" name="id" value="{{ $p->id }}">
                      <button class="btn btn-sm btn-outline-danger">Delete</button>
                    </form>
                  </td>
                </tr>
              @endforeach
            </tbody>
          </table>
        </div>
      </div>
    </div>
  </div>
</div>
</div>
@endsection

