@extends('app')
@section('title', 'AAdvantage Miles Leaderboard')
@section('css')
<style>
  /* Ensure the content sits below the American hero/header */
  #kt_content_container { padding-top: 44px !important; }
  .aam-shell{display:grid;grid-template-columns:240px 1fr;gap:16px;margin-top:44px}
  .aam-nav{background:var(--bs-body-secondary-bg);border-radius:10px;padding:12px;border:1px solid var(--bs-border-color)}
  .aam-nav a{display:flex;align-items:center;gap:10px;padding:10px 12px;color:var(--bs-body-color);border-radius:8px;text-decoration:none}
  .aam-nav a.active,.aam-nav a:hover{background:var(--bs-primary-bg-subtle);color:var(--bs-primary)}
  .cardish{background:var(--bs-body-secondary-bg);border-radius:12px;padding:16px;border:1px solid var(--bs-border-color);box-shadow:none}
  /* Header tiles */
  .tiles-grid{display:grid;grid-template-columns:repeat(auto-fit,minmax(200px,1fr));gap:12px}
  .tile{border-radius:12px;padding:12px 14px;color:#fff;position:relative;overflow:hidden}
  .tile .label{opacity:.9;font-size:.85rem}
  .tile .value{font-weight:700;font-size:1.3rem;line-height:1}
  .tile .icon{position:absolute;right:10px;top:10px;opacity:.25;font-size:22px}
  /* Tables */
  /* Stronger but not harsh header color with fallback */
  .log-table thead th{color:var(--bs-emphasis-color);color:rgba(var(--bs-emphasis-color-rgb),.88);font-weight:600}
  .log-table tbody td,.log-table tbody th{color:var(--bs-body-color) !important}
  .log-table tbody tr:hover{background-color:var(--bs-tertiary-bg)}
</style>
@endsection
@section('content')
<div class="aam-shell">
  @include('AAMiles::partials.sidebar', ['active' => 'company'])
  <div>
    <div class="cardish mb-3">
      <h2 class="mb-1" style="color:var(--bs-emphasis-color)"><i class="fas fa-gauge me-2"></i> AAdvantage Miles</h2>
      <div class="text-body-secondary">Top AAdvantage Holders</div>
      <div class="tiles-grid mt-3">
        <div class="tile bg-primary">
          <div class="label">All Time Top Miles</div>
          <div class="value">Top 50</div>
          <i class="fas fa-crown icon"></i>
        </div>
        <div class="tile bg-success">
          <div class="label">This Month</div>
          <div class="value">Top 50</div>
          <i class="far fa-calendar icon"></i>
        </div>
      </div>
    </div>

    <div class="row g-3">
      <div class="col-12 col-lg-6">
        <div class="cardish">
          <h5 class="mb-2"><i class="fas fa-crown me-2 text-warning"></i> All Time Top 50</h5>
          <div class="table-responsive">
            <table class="table table-sm table-striped mb-0 log-table">
              <thead>
                <tr>
                  <th>Pilot</th>
                  <th class="text-end">Miles</th>
                </tr>
              </thead>
              <tbody>
              @foreach($all_time as $row)
                <tr>
                  <td><i class="fas fa-user me-1 text-primary"></i> {{ optional(\App\Models\User::find($row->user_id))->name ?? ('Pilot #'.$row->user_id) }}</td>
                  <td class="text-end fw-semibold">{{ (int)$row->total }}</td>
                </tr>
              @endforeach
              </tbody>
            </table>
          </div>
        </div>
      </div>
      <div class="col-12 col-lg-6">
        <div class="cardish">
          <h5 class="mb-2"><i class="far fa-calendar me-2 text-success"></i> This Month Top 50</h5>
          <div class="table-responsive">
            <table class="table table-sm table-striped mb-0 log-table">
              <thead>
                <tr>
                  <th>Pilot</th>
                  <th class="text-end">Miles</th>
                </tr>
              </thead>
              <tbody>
              @foreach($monthly as $row)
                <tr>
                  <td><i class="fas fa-user me-1 text-primary"></i> {{ optional(\App\Models\User::find($row->user_id))->name ?? ('Pilot #'.$row->user_id) }}</td>
                  <td class="text-end fw-semibold">{{ (int)$row->total }}</td>
                </tr>
              @endforeach
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>

    <div class="cardish mt-3">
      <div class="bg-warning text-dark rounded-3 px-3 py-2 mb-2 d-flex align-items-center">
        <i class="fas fa-clock-rotate-left me-2"></i> Recent Activity
      </div>
      <div class="table-responsive">
        <table class="table table-sm table-striped mb-0 log-table">
          <thead>
            <tr>
              <th>Date</th>
              <th>Pilot</th>
              <th>Source</th>
              <th>Note</th>
              <th class="text-end">Miles</th>
            </tr>
          </thead>
          <tbody>
          @foreach($recent as $row)
            <tr>
              <td><i class="far fa-calendar me-1 text-primary"></i> {{ $row->created_at }}</td>
              <td><i class="fas fa-user me-1 text-info"></i> {{ optional(\App\Models\User::find($row->user_id))->name ?? ('Pilot #'.$row->user_id) }}</td>
              <td><i class="fas fa-tag me-1 text-success"></i> {{ $row->source }}</td>
              <td>{{ $row->note }}</td>
              <td class="text-end fw-semibold">
                @php $m = (int)($row->miles ?? 0); @endphp
                @if($m >= 0)
                  <i class="fas fa-arrow-up text-success me-1 fa-xs"></i>{{ $m }}
                @else
                  <i class="fas fa-arrow-down text-danger me-1 fa-xs"></i>{{ $m }}
                @endif
              </td>
            </tr>
          @endforeach
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>
@endsection
