@extends('app')
@section('title', 'My AAdvantage Miles')
@section('css')
<style>
  /* Ensure the content sits below the American hero/header */
  #kt_content_container { padding-top: 44px !important; }
  .aam-shell{display:grid;grid-template-columns:240px 1fr;gap:16px;margin-top:44px}
  .aam-nav{background:var(--bs-body-secondary-bg);border-radius:10px;padding:12px;border:1px solid var(--bs-border-color)}
  .aam-nav a{display:flex;align-items:center;gap:10px;padding:10px 12px;color:var(--bs-body-color);border-radius:8px;text-decoration:none}
  .aam-nav a.active,.aam-nav a:hover{background:var(--bs-primary-bg-subtle);color:var(--bs-primary)}
  .cardish{background:var(--bs-body-secondary-bg);border-radius:12px;padding:16px;border:1px solid var(--bs-border-color);box-shadow:none}
  .cardish h5{color:var(--bs-emphasis-color)}
  /* Colorful tiles (American theme colors via Bootstrap vars) */
  .tiles-grid{display:grid;grid-template-columns:repeat(auto-fit,minmax(180px,1fr));gap:12px}
  .tile{border-radius:12px;padding:14px 16px;color:#fff;position:relative;overflow:hidden}
  .tile .label{opacity:.9;font-size:.85rem}
  .tile .value{font-weight:700;font-size:1.4rem;line-height:1}
  .tile .icon{position:absolute;right:10px;top:10px;opacity:.25;font-size:24px}
  /* History table polish */
  /* Stronger but not harsh header color with fallback */
  .log-table thead th{color:var(--bs-emphasis-color);color:rgba(var(--bs-emphasis-color-rgb),.88);font-weight:600}
  .log-table tbody td,.log-table tbody th{color:var(--bs-body-color) !important}
  .log-table tbody tr:hover{background-color:var(--bs-tertiary-bg)}
</style>
@endsection
@section('content')
<div class="aam-shell">
  @include('AAMiles::partials.sidebar', ['active' => 'dashboard'])
  <div>
    <div class="cardish mb-3">
      <h2 class="mb-1" style="color:var(--bs-emphasis-color)"><i class="fas fa-gauge me-2"></i> AAdvantage Miles</h2>
      <div class="text-body-secondary">Overview of your AAdvantage miles and recent activity</div>
    </div>

    <div class="cardish mb-3">
      <div class="tiles-grid">
        <div class="tile bg-primary">
          <div class="label">Total Balance</div>
          <div class="value">{{ (int)($totals->total ?? 0) }}</div>
          <i class="fas fa-wallet icon"></i>
        </div>
        <div class="tile bg-success">
          <div class="label">Total Earned</div>
          <div class="value">{{ (int)($totals->earned ?? 0) }}</div>
          <i class="fas fa-arrow-trend-up icon"></i>
        </div>
        <div class="tile bg-danger">
          <div class="label">Total Spent</div>
          <div class="value">{{ (int)($totals->spent ?? 0) }}</div>
          <i class="fas fa-arrow-trend-down icon"></i>
        </div>
        <div class="tile bg-warning text-dark">
          <div class="label">This Month</div>
          <div class="value">{{ (int)($monthly->total ?? 0) }}</div>
          <i class="fas fa-calendar-week icon"></i>
        </div>
      </div>
    </div>

    <div class="cardish">
      <h5 class="mb-2" style="color:var(--bs-emphasis-color)"><i class="fas fa-clock-rotate-left me-2"></i> History</h5>
      <div class="table-responsive">
        <table class="table table-sm table-striped table-hover align-middle text-nowrap mb-0 log-table">
          <thead>
            <tr>
              <th>Date</th>
              <th>Source</th>
              <th>Note</th>
              <th class="text-end">Miles</th>
            </tr>
          </thead>
          <tbody>
          @foreach($history as $row)
            <tr class="{{ ($row->miles ?? 0) >= 0 ? 'earned' : 'spent' }}">
              <td class="text-body"><i class="far fa-calendar me-1 text-primary"></i> {{ $row->created_at }}</td>
              <td class="text-body"><i class="fas fa-tag me-1 text-success"></i> {{ $row->source }}</td>
              <td class="text-body">{{ $row->note }}</td>
              <td class="text-end">
                <span class="badge rounded-pill {{ ($row->miles ?? 0) >= 0 ? 'bg-success' : 'bg-danger' }}">{{ $row->miles }}</span>
              </td>
            </tr>
          @endforeach
          </tbody>
        </table>
      </div>
      <div class="mt-2">{{ $history->links() }}</div>
    </div>
  </div>
</div>
@endsection
