@extends('app')
@section('title', 'My Purchases')
@section('css')
<style>
  /* Ensure the content sits below the American hero/header */
  #kt_content_container { padding-top: 44px !important; }
  .aam-shell{display:grid;grid-template-columns:240px 1fr;gap:16px;margin-top:44px}
  .aam-nav{background:var(--bs-body-secondary-bg);border-radius:10px;padding:12px;border:1px solid var(--bs-border-color)}
  .aam-nav a{display:flex;align-items:center;gap:10px;padding:10px 12px;color:var(--bs-body-color);border-radius:8px;text-decoration:none}
  .aam-nav a.active,.aam-nav a:hover{background:var(--bs-primary-bg-subtle);color:var(--bs-primary)}
  /* Shared card look used across Miles pages */
  .cardish{background:var(--bs-body-secondary-bg);border-radius:12px;padding:16px;border:1px solid var(--bs-border-color);box-shadow:none}
  .cardish h5{color:var(--bs-emphasis-color)}
  /* History table polish */
  .log-table thead th{color:var(--bs-emphasis-color);color:rgba(var(--bs-emphasis-color-rgb),.88);font-weight:600}
  .log-table tbody td,.log-table tbody th{color:var(--bs-body-color) !important}
  .log-table tbody tr:hover{background-color:var(--bs-tertiary-bg)}
</style>
@endsection
@section('content')
<div class="aam-shell">
  @include('AAMiles::partials.sidebar', ['active' => 'purchases'])
  <div>
    <div class="cardish mb-3">
      <h2 class="mb-1" style="color:var(--bs-emphasis-color)"><i class="fas fa-receipt me-2"></i> My Purchases</h2>
      <div class="text-body-secondary">List of items you have redeemed in the AAdvantage Shop</div>
    </div>
    <div class="cardish">
      <div class="table-responsive">
        <table class="table table-sm table-striped table-hover align-middle text-nowrap mb-0 log-table">
          <thead>
            <tr>
              <th>Date</th>
              <th>Item</th>
              <th class="text-end">Miles</th>
              <th class="text-center">Action</th>
            </tr>
          </thead>
          <tbody>
          @foreach($orders as $o)
            @php($p = \Modules\AAdvantageMiles\Models\ShopProduct::find($o->product_id))
            @php($is_pass = (($p->meta['type'] ?? '') === 'flight_pass'))
            @php($flight_id = ($is_pass ? ($p->meta['flight_id'] ?? null) : null))
            @php($pass_ac_id = ($is_pass ? (int)($p->meta['aircraft_id'] ?? 0) : 0))
            @php($used = (bool)(($o->meta['used'] ?? false)))
            <tr>
              <td><i class="far fa-calendar me-1 text-primary"></i> {{ $o->created_at }}</td>
              <td><i class="fas fa-box me-1 text-info"></i> {{ $p?->name ?? ('#'.$o->product_id) }}</td>
              <td class="text-end fw-semibold">-{{ (int)$o->cost_miles }}</td>
              <td class="text-center">
                @if($is_pass && $flight_id && !$used)
                  <button type="button" class="btn btn-sm btn-primary bid-pass"
                          data-flight-id="{{ $flight_id }}"
                          @if($pass_ac_id > 0) data-aircraft-id="{{ $pass_ac_id }}" @endif>
                    Bid this flight
                  </button>
                @elseif($is_pass && $used)
                  <span class="badge bg-success">Used</span>
                  @if(!empty($o->meta['pirep_id']))
                    <a href="{{ route('frontend.pireps.show', $o->meta['pirep_id']) }}" class="btn btn-sm btn-outline-primary ms-1">View PIREP</a>
                  @endif
                @endif
                <form method="post" action="{{ url('aadvantage-miles/purchases/'.$o->id.'/delete') }}" class="d-inline ms-1" onsubmit="return confirm('Delete this purchase? Miles will be refunded if unused.');">
                  @csrf
                  <button type="submit" class="btn btn-sm btn-outline-danger">Delete</button>
                </form>
              </td>
            </tr>
          @endforeach
          </tbody>
        </table>
      </div>
      <div class="mt-2">{{ $orders->links('pagination::bootstrap-4') }}</div>
@section('scripts')
<script>
  document.addEventListener('DOMContentLoaded', function () {
    const btns = document.querySelectorAll('button.bid-pass[data-flight-id]');
    btns.forEach(btn => {
      btn.addEventListener('click', function (e) {
        e.preventDefault();
        const flightId = this.getAttribute('data-flight-id');
        const acId = this.getAttribute('data-aircraft-id');
        // Use the same JS API as the Flights page to avoid form-post reload issues
        const fn = acId ? phpvms.bids.addBid(flightId, acId) : phpvms.bids.addBid(flightId);
        fn.then(() => {
          window.location.href = "{{ route('frontend.flights.bids') }}";
        }).catch((error) => {
          const msg = (error && error.response && error.response.data) ? (error.response.data.details || error.message) : (error && error.message) || 'Error';
          alert('Error adding bid: ' + msg);
        });
      });
    });
  });
</script>
@endsection

    </div>
  </div>
</div>
@endsection
