@extends('app')
@section('title', 'AAdvantage Shop')
@section('css')
<style>
  /* Match American theme spacing like other AAM pages */
  #kt_content_container { padding-top: 44px !important; }
  .aam-shell{display:grid;grid-template-columns:240px 1fr;gap:16px;margin-top:44px}
  .aam-nav{background:var(--bs-body-secondary-bg);border-radius:10px;padding:12px;border:1px solid var(--bs-border-color);align-self:start}
  .aam-nav a{display:flex;align-items:center;gap:10px;padding:10px 12px;color:var(--bs-body-color);border-radius:8px;text-decoration:none}
  .aam-nav a.active,.aam-nav a:hover{background:var(--bs-primary-bg-subtle);color:var(--bs-primary)}

  /* Shop cards */
  .shop-grid{display:grid;grid-template-columns:repeat(3,minmax(220px,1fr));gap:12px}
  @media (max-width: 992px){.shop-grid{grid-template-columns:repeat(2,minmax(220px,1fr))}}
  @media (max-width: 576px){.shop-grid{grid-template-columns:1fr}}
  .shop-card{background:var(--bs-dark-bg-subtle, #111);border:1px solid rgba(255,255,255,.05);border-radius:.5rem}
  .shop-card .hdr{padding:.5rem .75rem;border-bottom:1px solid rgba(255,255,255,.06)}
  .shop-card .bd{padding:.75rem}
  .shop-card img{max-width:100%;height:auto;border-radius:.25rem}
</style>
@endsection
@section('content')
<div class="aam-shell">
  @include('AAMiles::partials.sidebar', ['active' => 'shop'])
  <div>
    <div class="cardish mb-3">
      <h2 class="mb-1" style="color:var(--bs-emphasis-color)"><i class="fas fa-store me-2"></i> AAdvantage Shop</h2>
      <div class="text-body-secondary">Redeem your AAdvantage miles for items</div>
    </div>

    @foreach($cats as $cat)
      <div class="cardish mb-3">
        <div class="bg-warning text-dark rounded-3 px-3 py-2 mb-2 d-flex align-items-center">
          <i class="fas fa-layer-group me-2"></i>
          <strong>{{ $cat->name }}</strong>
        </div>
        <div class="shop-grid">
          @foreach(($products[$cat->id] ?? collect()) as $p)
          <div class="shop-card">
            <div class="hdr"><strong>{{ $p->name }}</strong></div>
            <div class="bd">
              @if($p->image_url)
                <img src="{{ $p->image_url }}" alt="{{ $p->name }}" class="mb-2" />
              @endif
              <div class="small mb-2">{!! \Illuminate\Support\Str::limit(strip_tags($p->description ?? ''), 120) !!}</div>
              <div class="d-flex justify-content-between align-items-center">
                <div class="fw-semibold">{{ (int)$p->cost_miles }} miles</div>
                <form method="post" action="{{ route('AAMiles.shop.buy', $p->id) }}">
                  @csrf
                  <button class="btn btn-sm btn-primary" type="submit"><i class="fas fa-cart-plus me-1"></i> Buy</button>
                </form>
              </div>
            </div>
          </div>
          @endforeach
        </div>
      </div>
    @endforeach
  </div>
</div>
@endsection
