<?php

use App\Contracts\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

class AddEnforceRankBidsToSettings extends Migration
{
    public function up()
    {
        if (Schema::hasTable('aadv_miles_settings') && !Schema::hasColumn('aadv_miles_settings', 'enforce_rank_bids')) {
            Schema::table('aadv_miles_settings', function (Blueprint $table) {
                $table->boolean('enforce_rank_bids')->default(false)->after('shop_airline_id');
            });
            DB::table('aadv_miles_settings')->updateOrInsert(['id' => 1], ['enforce_rank_bids' => false]);
        }
    }

    public function down()
    {
        if (Schema::hasTable('aadv_miles_settings') && Schema::hasColumn('aadv_miles_settings', 'enforce_rank_bids')) {
            Schema::table('aadv_miles_settings', function (Blueprint $table) {
                $table->dropColumn('enforce_rank_bids');
            });
        }
    }
}

