<?php

namespace Modules\AAdvantageMiles\Providers;

use App\Services\ModuleService;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\ServiceProvider;

class AppServiceProvider extends ServiceProvider
{
    public function boot()
    {
        // Register views
        $this->loadViewsFrom(array_merge(array_map(function ($path) {
            return str_replace('default', setting('general.theme'), $path).'/modules/AAdvantageMiles';
        }, \Config::get('view.paths')), [__DIR__.'/../Resources/views']), 'AAMiles');

        // Load module migrations
        $this->loadMigrationsFrom(__DIR__.'/../Database/migrations');

        // Publishable config or assets could go here later
        $this->publishes([], 'aamiles-config');

        // Register route middleware alias via our kernel provider
        $this->app->register(\Modules\AAdvantageMiles\Providers\Kernel::class);

        // Admin menu links
        $moduleSvc = app(ModuleService::class);
        $moduleSvc->addAdminLink('AAdvantage Miles', '/admin/aamiles', 'pe-7s-graph');
        $moduleSvc->addAdminLink('AAdvantage Shop', '/admin/aamiles/shop', 'pe-7s-shopbag');
    }

    public function register()
    {
        // Ensure our module routes are registered
        $this->app->register(\Modules\AAdvantageMiles\Providers\RouteServiceProvider::class);
    }
}

