@extends('admin.app')
@section('title', 'Manage Pilot Miles')
@section('css')
  <style>.aam-admin-pad{padding:16px}.mini{font-size:12px;color:#666}</style>
@endsection
@section('content')
<div class="aam-admin-pad">
  <div class="card border-blue-bottom">
    <div class="header"><h4 class="title">Find Pilot</h4></div>
    <div class="content">
      <form method="get" action="{{ route('AAMiles.admin.manage') }}" class="form-group">
        <div class="row">
          <div class="form-group col-sm-6">
            <label>Search by Ident, Name, or Email</label>
            <input type="text" class="form-control" name="q" value="{{ $q ?? '' }}" placeholder="e.g. AAL001 or Jane Doe or jane@doe.com">
          </div>
          <div class="form-group col-sm-2 text-center">
            <br>
            <button class="btn btn-primary" type="submit">Search</button>
          </div>
        </div>
      </form>
    </div>
  </div>

  @if($user)
    <div class="card border-blue-bottom">
      <div class="header"><h4 class="title">Pilot</h4></div>
      <div class="content">
        <p><strong>{{ $user->ident }}</strong> — {{ $user->name }} <span class="mini">({{ $user->email }})</span></p>
        <div class="row">
          <div class="col-sm-3"><strong>Current Balance</strong><div>{{ (int)($balance->total ?? 0) }}</div></div>
          <div class="col-sm-3"><strong>Total Earned</strong><div>{{ (int)($balance->earned ?? 0) }}</div></div>
          <div class="col-sm-3"><strong>Total Spent</strong><div>{{ (int)($balance->spent ?? 0) }}</div></div>
        </div>
      </div>
    </div>

    <div class="row">
      <div class="col-sm-6">
        <div class="card border-blue-bottom">
          <div class="header"><h4 class="title">Give or Take Miles</h4></div>
          <div class="content">
            <form method="post" action="{{ route('AAMiles.admin.manage.adjust') }}" class="form-group">
              @csrf
              <input type="hidden" name="user_id" value="{{ $user->id }}">
              <input type="hidden" name="return_q" value="{{ $q }}">
              <div class="row">
                <div class="form-group col-sm-6">
                  <label>Amount (positive or negative)</label>
                  <input type="number" class="form-control" name="amount" placeholder="e.g. 500 or -500" required>
                </div>
                <div class="form-group col-sm-12">
                  <label>Message (reason)</label>
                  <input type="text" class="form-control" name="note" maxlength="200" required placeholder="Short reason shown in history">
                </div>
                <div class="form-group col-sm-12">
                  <button type="submit" class="btn btn-primary">Give or Take Miles</button>
                </div>
              </div>
            </form>
          </div>
        </div>
      </div>
      <div class="col-sm-6">
        <div class="card border-blue-bottom">
          <div class="header"><h4 class="title">Recent History</h4></div>
          <div class="content">
            <div class="content table-responsive table-full-width">
              <table class="table table-hover">
                <thead><tr><th>Date</th><th>Source</th><th>Note</th><th class="text-right">Miles</th></tr></thead>
                <tbody>
                @forelse($recent as $row)
                  <tr>
                    <td>{{ $row->created_at }}</td>
                    <td>{{ $row->source }}</td>
                    <td>{{ $row->note }}</td>
                    <td class="text-right {{ $row->miles < 0 ? 'text-danger' : 'text-success' }}">{{ (int)$row->miles }}</td>
                  </tr>
                @empty
                  <tr><td colspan="4" class="text-center text-muted">No recent entries</td></tr>
                @endforelse
                </tbody>
              </table>
            </div>
          </div>
        </div>
      </div>
    </div>
  @elseif(!empty($q))
    <div class="alert alert-warning">No pilot found for "{{ $q }}"</div>
  @endif
</div>
@endsection

