@extends('admin.app')
@section('title', 'AAdvantage Miles Settings')
@section('css')
  <style>.aam-admin-pad{padding:16px}</style>
@endsection
@section('content')
<div class="aam-admin-pad">
<div class="row">
  <div class="col-sm-8">
    <form method="post" action="{{ route('AAMiles.admin.save') }}" class="form-group">
      @csrf
      <div class="card border-blue-bottom">
        <div class="header"><h4 class="title">General</h4></div>
        <div class="content">
          <div class="checkbox">
            <label>
              <input type="checkbox" name="enabled" id="enabled" {{ (optional($settings)->enabled)?'checked':'' }}> Enable AAdvantage Miles
            </label>
          </div>
          <div class="checkbox">
            <label>
              <input type="checkbox" name="daily_visit_enabled" id="daily_visit_enabled" {{ (optional($settings)->daily_visit_enabled)?'checked':'' }}> Daily login enabled
            </label>
          </div>
          <div class="form-group">
            <label>Daily login miles</label>
            <input class="form-control" type="number" name="daily_visit_miles" value="{{ old('daily_visit_miles', optional($settings)->daily_visit_miles) }}" />
          </div>
        </div>
      </div>

      <div class="card border-blue-bottom">
        <div class="header"><h4 class="title">PIREP Rules</h4></div>
        <div class="content">
          <div class="checkbox">
            <label>
              <input type="checkbox" name="miles_per_min_enabled" id="miles_per_min_enabled" {{ (optional($settings)->miles_per_min_enabled)?'checked':'' }}> Miles per minute enabled
            </label>
          </div>
          <div class="form-group">
            <label>Miles per minute</label>
            <input class="form-control" type="number" name="miles_per_min" value="{{ old('miles_per_min', optional($settings)->miles_per_min) }}" />
          </div>
          <hr>
          <div class="checkbox">
            <label>
              <input type="checkbox" name="smooth_enabled" id="smooth_enabled" {{ (optional($settings)->smooth_enabled)?'checked':'' }}> Smooth landing bonus enabled
            </label>
          </div>
          <div class="row">
            <div class="form-group col-sm-4">
              <label>Smooth limit (FPM, e.g., -200)</label>
              <input class="form-control" type="number" name="smooth_limit" value="{{ old('smooth_limit', optional($settings)->smooth_limit) }}" />
            </div>
            <div class="form-group col-sm-4">
              <label>Smooth miles</label>
              <input class="form-control" type="number" name="smooth_miles" value="{{ old('smooth_miles', optional($settings)->smooth_miles) }}" />
            </div>
          </div>
          <hr>
          <div class="checkbox">
            <label>
              <input type="checkbox" name="bad_enabled" id="bad_enabled" {{ (optional($settings)->bad_enabled)?'checked':'' }}> Bad landing penalty enabled
            </label>
          </div>
          <div class="row">
            <div class="form-group col-sm-4">
              <label>Bad limit (FPM, e.g., -500)</label>
              <input class="form-control" type="number" name="bad_limit" value="{{ old('bad_limit', optional($settings)->bad_limit) }}" />
            </div>
            <div class="form-group col-sm-4">
              <label>Bad miles (deducted)</label>
              <input class="form-control" type="number" name="bad_miles" value="{{ old('bad_miles', optional($settings)->bad_miles) }}" />
            </div>
          </div>
          <hr>
          <div class="checkbox">
            <label>
              <input type="checkbox" name="score_bonus_enabled" id="score_bonus_enabled" {{ (optional($settings)->score_bonus_enabled)?'checked':'' }}> PIREP score bonus enabled
            </label>
          </div>
          <div class="form-group">
            <label>Score bonus cap (max miles)</label>
            <input class="form-control" type="number" name="score_max" value="{{ old('score_max', optional($settings)->score_max) }}" />
          </div>
          <hr>
          <div class="form-group">
            <label>Shop Airline Filter (Airline ID)</label>
            <input class="form-control" type="number" name="shop_airline_id" value="{{ old('shop_airline_id', optional($settings)->shop_airline_id ?? 1) }}" />
            <small class="text-muted">Used to filter flight searches for Flight Pass products. Set to your Airline ID (or leave as the lowest Airline ID).</small>
          </div>
          <div class="checkbox mt-2">
            <label>
              <input type="checkbox" name="enforce_rank_bids" {{ (optional($settings)->enforce_rank_bids)?'checked':'' }}> Enforce rank/type restrictions on Flight Pass bids
            </label>
            <div class="text-muted small">Unchecked = Flight Pass can bypass rank/type (only departure lock applies). Checked = bids must satisfy current VA rank/type settings.</div>
          </div>
          <hr>
          <div class="form-group">
            <label>Airport miles</label>
            <div id="airport-miles-rows">
              @php($airportMiles = collect(optional($settings)->airport_miles ?? [])->sortBy('icao')->values()->all())
              @foreach($airportMiles as $idx => $row)
                <div class="row airport-mile-row" style="margin-bottom:10px;">
                  <div class="form-group col-sm-5">
                    <label>Airport</label>
                    <select name="airport_miles[{{ $idx }}][icao]" class="form-control select2 airport_search">
                      @if(!empty($row['icao']))
                        <option value="{{ $row['icao'] }}" selected>{{ $row['icao'] }}</option>
                      @endif
                    </select>
                  </div>
                  <div class="form-group col-sm-3">
                    <label>When</label>
                    @php($when = strtolower($row['when'] ?? 'both'))
                    <select name="airport_miles[{{ $idx }}][when]" class="form-control">
                      <option value="departure" {{ $when==='departure' ? 'selected' : '' }}>Departure</option>
                      <option value="arrival" {{ $when==='arrival' ? 'selected' : '' }}>Arrival</option>
                      <option value="both" {{ $when==='both' ? 'selected' : '' }}>Both</option>
                    </select>
                  </div>
                  <div class="form-group col-sm-2">
                    <label>Miles</label>
                    <input type="number" class="form-control" name="airport_miles[{{ $idx }}][miles]" value="{{ $row['miles'] ?? 1000 }}">
                  </div>
                  <div class="form-group col-sm-2">
                    <button type="button" class="btn btn-danger remove-airport-row">Remove</button>
                  </div>
                </div>
              @endforeach
            </div>
            <button type="button" class="btn btn-primary" id="add-airport-row">Add airport</button>
            <p class="text-muted">List is shown sorted by ICAO; default miles for a new row is 1000.</p>
          </div>
        </div>
      </div>

      <div class="row">
        <div class="col-sm-12 text-center">
          <button class="btn btn-primary" type="submit">Save</button>
        </div>
      </div>
    </form>
  </div>
</div>
<div class="row" style="margin-top: 12px;">
  <div class="col-sm-12">
    <a href="{{ route('AAMiles.admin.shop') }}" class="btn btn-default">Open AAdvantage Shop Admin</a>
    <a href="{{ route('AAMiles.admin.manage') }}" class="btn btn-default">Manage Pilot Miles</a>
  </div>
</div>
</div>
@endsection
@section('scripts')
  @include('admin.scripts.airport_search')
  <script>
    $(function(){
      const container = $('#airport-miles-rows');
      const defaultMiles = 1000;

      function initAirportSelect($el){
        $el.select2({
          ajax: {
            url: BASE_URL + '/api/airports/search',
            data: function (params) {
              const hubs_only = $el.hasClass('hubs_only') ? 1 : 0;
              return {
                search: params.term,
                hub: hubs_only,
                page: params.page || 1,
                orderBy: 'id',
                sortedBy: 'asc'
              };
            },
            processResults: function (data, params) {
              if (!data.data) { return { results: [] }; }
              const results = data.data.map(apt => ({ id: apt.id, text: apt.description }));
              return { results, pagination: { more: data.meta && data.meta.next_page !== null } };
            },
            cache: true,
            dataType: 'json',
            delay: 250
          },
          width: 'resolve',
          placeholder: 'Type to search',
          minimumInputLength: 2
        });
      }

      // Ensure existing rows are initialized (in case the include didn't for some reason)
      $('select.airport_search').each(function(){ initAirportSelect($(this)); });

      function nextIndex(){
        let max = -1;
        container.find('.airport-mile-row').each(function(){
          const name = $(this).find('select, input[type=number]').first().attr('name') || '';
          const m = name.match(/airport_miles\[(\d+)\]/);
          if(m){ max = Math.max(max, parseInt(m[1],10)); }
        });
        return max + 1;
      }

      $('#add-airport-row').on('click', function(){
        const idx = nextIndex();
        const row = $(
          '<div class="row g-2 align-items-end mb-2 airport-mile-row">\
            <div class="col-md-5">\
              <label class="form-label">Airport</label>\
              <select name="airport_miles['+idx+'][icao]" class="form-control select2 airport_search"></select>\
            </div>\
            <div class="col-md-3">\
              <label class="form-label">When</label>\
              <select name="airport_miles['+idx+'][when]" class="form-control">\
                <option value="departure">Departure</option>\
                <option value="arrival">Arrival</option>\
                <option value="both" selected>Both</option>\
              </select>\
            </div>\
            <div class="col-md-2">\
              <label class="form-label">Miles</label>\
              <input type="number" class="form-control" name="airport_miles['+idx+'][miles]" value="'+defaultMiles+'">\
            </div>\
            <div class="col-md-2">\
              <button type="button" class="btn btn-outline-danger remove-airport-row">Remove</button>\
            </div>\
          </div>'
        );
        container.append(row);
        const $newSelect = row.find('select.airport_search');
        initAirportSelect($newSelect);
      });

      $(document).on('click', '.remove-airport-row', function(){
        $(this).closest('.airport-mile-row').remove();
      });
    });
  </script>
@endsection

