<?php

namespace Modules\AAdvantageMiles\Services;

use Illuminate\Support\Facades\DB;
use Modules\AAdvantageMiles\Models\MilesHistory;

class MilesLedger
{
    public function add(
        int $user_id,
        int $miles,
        string $source,
        string $event_id = '',
        string $note = '',
        ?array $meta = null,
        ?int $issued_by = null,
        ?string $unique_key = null
    ): bool {
        if ($unique_key) {
            // Cheap idempotency check using unique_key
            $exists = MilesHistory::where('unique_key', $unique_key)->exists();
            if ($exists) {
                return false; // already added
            }
        }

        try {
            MilesHistory::create([
                'user_id'    => $user_id,
                'issued_by'  => $issued_by,
                'source'     => $source,
                'event_id'   => $event_id,
                'note'       => $note,
                'miles'      => $miles,
                'meta'       => $meta,
                'unique_key' => $unique_key,
                'created_at' => now(),
            ]);
            return true;
        } catch (\Throwable $e) {
            // In case of race, unique_key unique index will throw; swallow as success/no-op
            return false;
        }
    }
}

