# AAdvantage Miles (phpVMS v7 module)

Lightweight, production-tested "miles/points" system for phpVMS v7. Includes a simple ledger, automatic awards (daily login, flight rules), leaderboards, and an optional in‑VA shop with Flight Passes that allow direct bids for selected flights.

This module is designed to be theme‑agnostic and easy to install.

## Features
- Miles ledger per user (earn/spend entries)
- Automatic awards
  - Daily login miles (idempotent per day)
  - PIREP rules: miles per minute, smooth/bad landing bonuses/penalties, score bonus with cap
  - Airport‑specific bonuses (per rule: departure/arrival/both)
- Frontend pages
  - My Miles (/aadvantage-miles)
  - Leaderboard (/aadvantage-miles/leaderboard)
  - Shop (/aadvantage-miles/shop) and Purchases (/aadvantage-miles/purchases)
- Admin pages
  - Settings (enable toggles, per‑rule configuration, airport bonuses)
  - Manage Pilot Miles (search and adjust a pilot’s balance, with recent history)
  - Shop Admin (categories/products, limits, and purchase ledger)
- Flight Passes (optional)
  - Create products as "Flight Pass" with flight_id (and optional aircraft_id)
  - Users can place a bid directly via POST /aamiles/pass/bid if they own a valid pass
  - Pass is auto‑marked used when the related PIREP files

## Requirements
- phpVMS v7 (Laravel 8+) environment
- Ability to run database migrations (CLI recommended)

No external packages are required.

## Installation
1) Download and unzip this module so that the folder structure is:
   modules/AAdvantageMiles/...

2) Enable the module:
   - Admin > Addons > Modules > Enable

3) Run migrations:
   - PHPVMS Update > Domain/update

4) Clear caches:
   - Admin > Maintenance > Clear All Caches

5) Open the Settings page:
   - Admin > AAdvantage Miles ("Settings")
   - Toggle features and set values (daily miles, per‑minute rate, landing thresholds, score cap, airport rules, etc.)

That’s it. Users will start earning miles based on your settings.

## Settings: important options
- Shop Airline Filter (Airline ID)
  - Used by Shop admin flight search to filter flights for Flight Pass products
  - Set this to your Airline ID; defaults to the lowest Airline ID in your DB on first install
- Enforce rank/type restrictions on Flight Pass bids
  - Off: Flight Pass bids bypass rank/type restrictions (only the core departure-airport lock applies)
  - On: Flight Pass bids must satisfy your VA’s current rank/type settings. The module validates that the pilot can fly the selected aircraft and that the aircraft’s subfleet is allowed for the flight.

## Routes / URLs
Frontend (user must be logged in):
- GET /aadvantage-miles → My Miles
- GET /aadvantage-miles/leaderboard → Leaderboard
- GET /aadvantage-miles/shop → Shop
- GET /aadvantage-miles/purchases → My Purchases
- POST /aamiles/pass/bid → Place bid using a Flight Pass

Admin (requires admin access):
- GET /admin/aamiles → Settings
- POST /admin/aamiles/settings → Save settings
- GET /admin/aamiles/manage → Manage pilot miles (search & adjust)
- POST /admin/aamiles/manage/adjust → Submit an adjustment
- GET /admin/aamiles/shop → Shop Admin (categories/products, ledger)
- POST /admin/aamiles/shop/categories → Create/update category
- POST /admin/aamiles/shop/products → Create/update product
- POST /admin/aamiles/shop/products/delete → Delete product

Note: For historical/theme compatibility, a couple of alias routes exist (e.g. /aadvantagemiles). If you prefer zero aliasing, you can remove those lines in Providers/RouteServiceProvider.

## Theming / Views
- Views are loaded with the namespace: AAMiles::
- You can override any view by copying it under your active theme:
  resources/views/<your-theme>/modules/AAdvantageMiles/

Key views to override/customize:
- Resources/views/frontend/my_miles.blade.php
- Resources/views/frontend/leaderboard.blade.php
- Resources/views/frontend/shop.blade.php
- Resources/views/frontend/purchases.blade.php
- Resources/views/admin/settings.blade.php
- Resources/views/admin/shop.blade.php
- Resources/views/admin/manage.blade.php

## Flight Passes (optional)
- In Admin > AAdvantage Shop, create a Product and enable the Flight Pass fields.
- Provide a flight_id (Flight ID only; this is precise and recommended)
- Optionally set an aircraft_id to pre‑bind SimBrief/aircraft for that bid.
- After purchase, the user can place a direct bid via the Shop UI (button in the views) or POST to /aamiles/pass/bid.
- When a PIREP for that flight is filed, the pass is auto‑marked used.
- Flight Passes created by the shop expire in 30 days by default.

## Uninstall / Removing
- Disable the module in Admin > Addons > Modules.
- Optionally drop tables: aadv_* (settings, history, shop_* and flight_passes).

## Troubleshooting
- Not seeing routes or views? Clear caches:
  php artisan config:clear && php artisan view:clear && php artisan route:clear
- If you cannot run CLI migrations, you can create tables manually using the migration file under: modules/AAdvantageMiles/Database/migrations

## Credits
- Developed for the American Virtual crew; packaged for the community.
- Base model: GPT‑5 via Augment Code, implementation by your VA.

## License (MIT)
Copyright (c) American Virtual and contributors

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

