<?php

use App\Contracts\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddAutoRepositionToTpaSettings extends Migration
{
    public function up()
    {
        if (Schema::hasTable('tpa_settings') && !Schema::hasColumn('tpa_settings', 'auto_reposition_on_first_bid')) {
            Schema::table('tpa_settings', function (Blueprint $table) {
                $table->boolean('auto_reposition_on_first_bid')->default(false)->after('lock_to_current_location');
            });
        }
    }

    public function down()
    {
        if (Schema::hasTable('tpa_settings') && Schema::hasColumn('tpa_settings', 'auto_reposition_on_first_bid')) {
            Schema::table('tpa_settings', function (Blueprint $table) {
                $table->dropColumn('auto_reposition_on_first_bid');
            });
        }
    }
}

