<?php

namespace Modules\TripPlannerAdvanced\Http\Controllers\Admin;

use App\Contracts\Controller;
use Illuminate\Http\Request;
use Modules\TripPlannerAdvanced\Models\TpaSettings;

class SettingsController extends Controller
{
    public function index()
    {
        $settings = TpaSettings::first();
        return view('tpa::admin.settings', compact('settings'));
    }

    public function save(Request $request)
    {
        // Always load the single settings row (create if missing)
        $settings = TpaSettings::first() ?? new TpaSettings();

        $data = $request->validate([
            'enforce_rank' => 'nullable',
            'lock_to_current_location' => 'nullable',
            'auto_reposition_on_first_bid' => 'nullable',
        ]);

        // Normalize checkboxes to booleans (no value when unchecked)
        foreach (['enforce_rank','lock_to_current_location','auto_reposition_on_first_bid'] as $cb) {
            $data[$cb] = $request->boolean($cb);
        }

        $settings->fill($data);
        $settings->save();

        return redirect()->back()->with('success', 'Settings saved');
    }
}

