<?php

namespace Modules\TripPlannerAdvanced\Providers;

use App\Contracts\Modules\ServiceProvider;
use Illuminate\Support\Facades\Config;

/**
 * @package $NAMESPACE$
 */
class AppServiceProvider extends ServiceProvider
{
    private $moduleSvc;

    protected $defer = false;

    /**
     * Boot the application events.
     */
    public function boot(): void
    {
        $this->moduleSvc = app('App\Services\ModuleService');

        $this->registerTranslations();
        $this->registerConfig();
        $this->registerViews();

        $this->registerLinks();

        // Migrations
        $this->loadMigrationsFrom(__DIR__ . '/../Database/migrations');
    }

    /**
     * Register the service provider.
     */
    public function register()
    {
        //
    }

    /**
     * Add module links here
     */
    public function registerLinks(): void
    {
        // Show this link if logged in
        $this->moduleSvc->addFrontendLink('Trip Planner', '/trip-planner', '', $logged_in=true);

        // No default admin links for now (admin routes exist; link can be added later)
    }

    /**
     * Register config.
     */
    protected function registerConfig()
    {
        $this->publishes([
            __DIR__.'/../Config/config.php' => config_path('tripplanneradvanced.php'),
        ], 'tripplanneradvanced');

        $this->mergeConfigFrom(__DIR__.'/../Config/config.php', 'tripplanneradvanced');
    }

    /**
     * Register views.
     */
    public function registerViews()
    {
        $viewPath = resource_path('views/modules/tripplanneradvanced');
        $sourcePath = __DIR__.'/../Resources/views';
        $theme = setting('general.theme', 'seven');
        $themePath = resource_path('views/layouts/'.$theme.'/modules/tripplanneradvanced');

        $this->publishes([$sourcePath => $viewPath],'views');

        // Always prefer the active theme override, then fall back to app-level overrides, then to the module defaults
        $this->loadViewsFrom([$themePath, $viewPath, $sourcePath], 'tpa');

        // Publish config for editing
        $this->publishes([
            __DIR__.'/../Config/config.php' => config_path('tripplanneradvanced.php'),
        ], 'config');
    }

    /**
     * Register translations.
     */
    public function registerTranslations()
    {
        $langPath = resource_path('lang/modules/tripplanneradvanced');

        if (is_dir($langPath)) {
            $this->loadTranslationsFrom($langPath, 'tpa');
        } else {
            $this->loadTranslationsFrom(__DIR__ .'/../Resources/lang', 'tpa');
        }
    }
}
