@section('scripts')
  @if (setting('bids.block_aircraft', false))
    <script>
      $(document).ready(function() {
        let aircrafts = [{
          id: 0,
          text: 'Loading Aircrafts...'
        }];
        let sel = $('#aircraft_select');

        $("button.save_flight").click(function(e) {
          e.preventDefault();

          const btn = $(this);
          const class_name = btn.attr('x-saved-class'); // classname to use is set on the element
          const flight_id = btn.attr('x-id');
          const not_saved = btn.attr('x-not-saved-class');
          $('#aircraft_select').attr('x-saved-class', class_name)
          $('#aircraft_select').attr('x-id', flight_id)
          $('#aircraft_select').attr('x-not-saved-class', not_saved)
          if (!btn.hasClass(class_name)) {
            $('#bidModal').modal();
            $.ajax({
              headers: {
                'X-API-KEY': $('meta[name="api-key"]').attr('content')
              },
              url: '/trip-planner/flights/' + flight_id + '/aircraft'
            }).then((response) => {
              aircrafts = [];
              const results = response.map(ac => {
                const text =
                  `[${ac.icao}] ${ac.registration} ${ac.registration !== ac.name ? ` ${ac.name}` : ''}`;

                aircrafts.push({
                  id: ac.id,
                  text: text
                })
              });
              $('#aircraft_select option').remove();
              sel.select2({
                dropdownParent: $('#bidModal'),
                data: aircrafts
              });
            });
          } else {
            phpvms.bids.removeBid(flight_id).then(() => {
              console.log('successfully removed flight');
              btn.removeClass(class_name).addClass(not_saved).text("Add Bid");
              location.reload();
            }).catch((error) => {
              if (error.response && error.response.data)
                alert(`Error removing bid: ${error.response.data.details}`)
              else alert(`Error removing bid: ${error.message}`)
            });
          }
        });


        $('#with_aircraft').click(() => {
          const ac_id = $('#aircraft_select').val()
          const flight_id = $('#aircraft_select').attr('x-id');
          const class_name = $('#aircraft_select').attr('x-saved-class')
          const not_saved = $('#aircraft_select').attr('x-not-saved-class')
          $.post('{{ route('tripplanner.bid.add') }}', { _token: '{{ csrf_token() }}', flight_id: flight_id, aircraft_id: ac_id })
            .done(() => {
              $('button.save_flight[x-id="' + flight_id + '"]').addClass(class_name).removeClass(not_saved).text("Remove Bid");
              location.reload();
            })
            .fail((xhr) => {
              if (xhr.responseJSON && xhr.responseJSON.message) alert('Error adding bid: ' + xhr.responseJSON.message); else alert('Error adding bid');
            });

        });

        $('#without_aircraft').click(async () => {
          const flight_id = $('#aircraft_select').attr('x-id');
          const class_name = $('#aircraft_select').attr('x-saved-class')
          const not_saved = $('#aircraft_select').attr('x-not-saved-class')

          $.post('{{ route('tripplanner.bid.add') }}', { _token: '{{ csrf_token() }}', flight_id: flight_id })
            .done(() => {
              $('button.save_flight[x-id="' + flight_id + '"]').addClass(class_name).removeClass(not_saved).text("Remove Bid");
              location.reload();
            })
            .fail((xhr) => {
              if (xhr.responseJSON && xhr.responseJSON.message) alert('Error adding bid: ' + xhr.responseJSON.message); else alert('Error adding bid');
            });
        });
      });
    </script>
  @else
    <script>
      $(document).ready(function() {
        $("button.save_flight").click(function(e) {
          e.preventDefault();

          const btn = $(this);
          const class_name = btn.attr('x-saved-class'); // classname to use is set on the element
          const flight_id = btn.attr('x-id');
          const not_saved = btn.attr('x-not-saved-class');

          if (!btn.hasClass(class_name)) {
            // Prefer module route so we can optionally reposition after first bid
            $.post('{{ route('tripplanner.bid.add') }}', { _token: '{{ csrf_token() }}', flight_id: flight_id })
              .done(() => {
                $('button.save_flight[x-id="' + flight_id + '"]').addClass(class_name).removeClass(not_saved).text("Remove Bid");
                location.reload();
              })
              .fail((xhr) => {
                if (xhr.responseJSON && xhr.responseJSON.message) alert('Error adding bid: ' + xhr.responseJSON.message); else alert('Error adding bid');
              });
          } else {
            phpvms.bids.removeBid(flight_id).then(() => {
              console.log('successfully removed flight');
              btn.removeClass(class_name).addClass(not_saved).text("Add Bid");
              location.reload();
            }).catch((error) => {
              if (error.response && error.response.data)
                alert(`Error removing bid: ${error.response.data.details}`)
              else alert(`Error removing bid: ${error.message}`)
            });
          }
        });
      });
    </script>
  @endif


  <script>
    $(function() {
      // Initialize Bootstrap 4 popovers for aircraft pills (explicit options)
      $('[data-toggle="popover"]').popover({
        trigger: 'hover focus',
        container: 'body',
        html: true,
        placement: 'top'
      });
    });
  </script>

  @include('scripts.airport_search')
@endsection
