<div class="table-responsive">
  <table class="table table-hover table-striped align-middle">
    <thead>
    <tr>
      <th style="width:28%">Trip</th>
      <th style="width:32%">Description</th>
      <th style="width:20%">Progress</th>
      <th style="width:12%">Created</th>
      <th style="width:8%" class="text-end">Actions</th>
    </tr>
    </thead>
    <tbody>

    @foreach($trips as $trip)
      @php
        $total = $trip->fpts()->count();
        $completed = $trip->fpts()->whereNotNull('pirep_id')->count();
        $percent = $total > 0 ? round($completed / $total * 100) : 0;
      @endphp
      <tr>
        <td>
          <a href="{{ route('tripplanner.show', [$trip->id]) }}" class="text-decoration-none">
            <i class="bi bi-signpost-split" aria-hidden="true"></i>&nbsp;{{ $trip->name }}
          </a>
          <div class="text-muted" style="font-size: 0.85rem;">
            <i class="bi bi-airplane" aria-hidden="true"></i>&nbsp;{{ $total }} {{ \Illuminate\Support\Str::plural('leg', $total) }}
          </div>
        </td>
        <td>
          @php $desc = trim((string)($trip->description ?? '')); @endphp
          @if($desc === '')
            <span class="text-muted">No description</span>
          @else
            {{ \Illuminate\Support\Str::limit($desc, 120) }}
          @endif
        </td>
        <td>
          <div class="progress" style="height: 10px;">
            <div class="progress-bar bg-info" role="progressbar" style="width: {{ $percent }}%" aria-valuenow="{{ $percent }}" aria-valuemin="0" aria-valuemax="100"></div>
          </div>
          <small class="text-muted">{{ $completed }}/{{ $total }} ({{ $percent }}%)</small>
        </td>
        <td>
          <i class="bi bi-clock" aria-hidden="true"></i>&nbsp;{{ optional($trip->created_at)->format('Y-m-d H:i') }}
        </td>
        <td class="text-end">
          <div class="btn-group btn-group-sm" role="group">
            <a href="{{ route('tripplanner.show', [$trip->id]) }}"
               class="btn btn-outline-info"
               style="z-index: 9999"
               title="View">
              <i class="bi bi-eye" aria-hidden="true"></i>
            </a>
            <form method="POST" action="{{ route('tripplanner.destroy', [$trip->id]) }}" style="display: inline-block;" onsubmit="return confirm('Are you sure you want to delete this trip? This action cannot be undone.')">
              @csrf
              @method('DELETE')
              <button type="submit" class="btn btn-outline-danger" title="Delete">
                <i class="bi bi-trash" aria-hidden="true"></i>
              </button>
            </form>
          </div>
        </td>
      </tr>
    @endforeach

    </tbody>
  </table>
</div>
