@extends('admin.app')
@section('title', 'Trip Planner Advanced - Settings')
@section('content')
<div class="row">
  <div class="col-sm-8">
    <form method="post" action="{{ route('admin.tripplanner.settings.save') }}" class="form-group">
      @csrf
      <div class="card border-blue-bottom">
        <div class="header"><h4 class="title">General</h4></div>
        <div class="content">
          <div class="checkbox">
            <label>
              <input type="checkbox" name="enforce_rank" {{ (optional($settings)->enforce_rank)?'checked':'' }}> Enforce VA Ranking
            </label>
            <div class="small text-info">When enabled, pilots can only use subfleets permitted by their rank/type ratings.</div>
          </div>
          <div class="checkbox">
            <label>
              <input type="checkbox" name="lock_to_current_location" {{ (optional($settings)->lock_to_current_location ?? true)?'checked':'' }}> Lock to current pilot location
            </label>
            <div class="small text-info">When enabled, the first leg must depart from the pilot's current (or home) airport.</div>
          </div>
          <div class="checkbox">
            <label>
              <input type="checkbox" name="auto_reposition_on_first_bid" {{ (optional($settings)->auto_reposition_on_first_bid ?? false)?'checked':'' }}> Auto‑Reposition pilot to trip start on first Bid
            </label>
            <div class="small text-warning">
              When “Lock to current pilot location” is OFF (start from anywhere), enable Auto‑Reposition so the pilot is moved to the first departure airport after their first Bid. Otherwise bids and PIREP submit may be blocked until the pilot is manually moved.
            </div>
          </div>

        </div>
      </div>

      <div class="row">
        <div class="col-sm-12 text-center">
          <button class="btn btn-primary" type="submit">Save</button>
        </div>
      </div>
    </form>
  </div>
</div>
@endsection

