<?php

use App\Contracts\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTpaSettingsTable extends Migration
{
    public function up()
    {
        if (!Schema::hasTable('tpa_settings')) {
            Schema::create('tpa_settings', function (Blueprint $table) {
                $table->id();
                $table->boolean('enforce_rank')->default(false);
                $table->boolean('lock_to_current_location')->default(true);
                $table->boolean('enable_legacy_trips_routes')->default(false);
                $table->timestamps();
            });
        }
    }

    public function down()
    {
        Schema::dropIfExists('tpa_settings');
    }
}

