<?php

namespace Modules\TripPlannerAdvanced\Http\Controllers\Frontend;

use App\Contracts\Controller;
use App\Models\Bid;
use App\Models\Flight;
use App\Repositories\FlightRepository;
use App\Services\BidService;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Modules\TripPlannerAdvanced\Http\Controllers\Frontend\Traits\RepositionOnBid;

class BidHookController extends Controller
{
    use RepositionOnBid;

    public function __construct(private readonly BidService $bidSvc, private readonly FlightRepository $flightRepo) {}

    /**
     * Add a bid and maybe reposition the pilot if enabled.
     */
    public function add(Request $request)
    {
        $user = Auth::user();
        $flight = $this->flightRepo->find($request->input('flight_id'));
        $aircraft_id = $request->input('aircraft_id');
        $bid = $this->bidSvc->addBid($flight, $user, $aircraft_id ? app('App\\Repositories\\AircraftRepository')->find($aircraft_id) : null);

        // After successful bid, run reposition logic if applicable
        $this->maybeAutoReposition($user, $flight);

        return redirect()->back()->with('success', 'Bid added');
    }
}

