# Trip Planner Advanced (phpVMS v7 module)

Create multi‑leg “trip” free flights, track progress, and keep pilots moving airport‑to‑airport. Clean routes, easy settings, and neutral branding for any VA. This is a community‑ready repackaging of CHTrips with a clearer UX, settings, and route structure.

## Key Features
- Create multi‑leg trips with name and description
- “Next flight” summary and trip progress tracking
- One‑click subfleet assignment per leg based on an Equipment Category (Airbus Narrow, Boeing Narrow, Airbus Wide, Boeing Wide, Regional, McDonnell/Other)
- Rank‑aware mode (optional) that honors phpVMS v7 subfleet/rank assignments
- Trip‑owned, invisible flights to avoid collisions with scheduled flights
- Optional legacy aliases under /trips

## Requirements
- phpVMS v7 (Laravel 8+)
- Ability to run migrations (Admin → Maintenance → Update or CLI)

## Installation
1) Copy or unzip the folder into `modules/TripPlannerAdvanced/`
2) In Admin → Addons → Modules, enable “TripPlannerAdvanced”
3) Run migrations: Admin → Maintenance → Update
4) Clear caches: Admin → Maintenance → Clear All Caches
5) The “Trip Planner” link appears in the frontend nav (for logged‑in users)

## Frontend Routes (names: `tripplanner.*`)
- `GET  /trip-planner` → `tripplanner.index` (My Trips)
- `GET  /trip-planner/create` → `tripplanner.create` (Create Trip)
- `POST /trip-planner` → `tripplanner.store`
- `GET  /trip-planner/{trip}` → `tripplanner.show` (Trip detail)
- `DELETE /trip-planner/{trip}` → `tripplanner.destroy`
- `POST /trip-planner/bid/add` → `tripplanner.bid.add` (Add bid + optional auto‑reposition)
- `GET  /trip-planner/pireps/create` → `tripplanner.pireps.create` (PIREP create bridge scoped to a Trip flight)
- `GET  /flights/{id}/aircraft` → `tripplanner.flights.aircraft` (AJAX list of aircraft for a flight; used by bid modal)

Optional legacy aliases (off by default): set `config('tripplanneradvanced.enable_legacy_trips_routes', true)` to also serve the pages under `/trips/*`.

## Admin Routes (names: `admin.tripplanner.*`)
- `GET  /admin/trip-planner/settings` → `admin.tripplanner.settings`
- `POST /admin/trip-planner/settings` → `admin.tripplanner.settings.save`

Permissions: guarded by `ability:admin,admin-access`. The settings section isn’t linked in the default admin menu; use the direct URL above or add your own menu link.

---

## Admin Settings — How They Work
Settings are stored in `tpa_settings` and surfaced under Admin → Trip Planner Advanced → Settings. All are simple on/off toggles.

1) Enforce VA Ranking
- When ON: Trip creation uses only the subfleets the pilot is allowed to fly (core phpVMS Rank/Type system).
- The Equipment Category picks from the allowed set only. If no subfleets match the category, creation fails with a clear error.
- When OFF: Rank/type restrictions are ignored at creation time. The category still controls which subfleets get attached to each leg.

2) Lock to Current Pilot Location
- When ON (default): The first leg must depart from the pilot’s current airport (or their home airport if the current is unknown). The create form validates this and shows a helpful error if mismatched.
- When OFF: Trips can start from any airport. In this mode the pilot may not be at the trip’s first departure—see Auto‑Reposition below.

3) Auto‑Reposition Pilot To Trip Start On First Bid
- When ON: After the pilot places their first Bid for any flight in a trip, their current location is automatically moved to the first leg’s departure airport.
- This only applies to flights owned by Trip Planner Advanced (the module marks created flights with a morph owner of `TripReport`).
- Safety guards:
  - Triggers only when the pilot’s total bids within that trip becomes exactly 1 (i.e., the very first bid).
  - No effect if already at the first‑leg departure.
- Recommended to enable this when “Lock to Current Pilot Location” is OFF, to avoid confusion and allow a smooth start.

Notes
- The trip detail page shows an info banner when “Lock to Current” is OFF and Auto‑Reposition is ON.
- Repositioning happens in the module’s bid add endpoint and does not affect normal scheduling bids.

---

## How Trips Are Created (Lifecycle)
- The create form captures Airline, Start Airport, legs (via + Add Leg), Trip Name/Description, and an Equipment Category.
- Flights are created with number range 7000–7999, `route_code=TPA`, `visible=false`, and are owned by the trip (`owner_type=TripReport`, `owner_id=<trip id>`).
- Subfleets are attached to each leg based on the chosen category and the ranking mode.
- A mapping row is stored for each leg in `ch_flight_pirep_trip` with an `order` field to keep sequence.

## Using Trips (Pilot UX)
- My Trips (index)
  - Tabular list with progress bar, trip description, created date, and actions.
- Trip Detail (show)
  - “Next Flight” card, action buttons (More Info, PIREP Create, SimBrief), and “Add/Remove Bid”.
  - Following flights list and completed PIREPs table.
- Bidding behavior
  - Add Bid posts to `tripplanner.bid.add` (so the module can optionally reposition on first bid).
  - Remove Bid uses the core `phpvms.bids.removeBid()` JS helper.
- PIREP Create Bridge
  - `tripplanner.pireps.create` returns the standard `pireps.create` view but filters the aircraft dropdown to subfleets allowed for the selected Trip flight, keeping pilots within the trip equipment scope.

## Database Tables
- `ch_trip_reports` (TripReport)
- `ch_flight_pirep_trip` (trip legs and PIREP mapping with `order`)
- `trip_report_user` (participants; creator is attached with `owner=true`)
- `tpa_settings` (module settings)

## Theming / Views
- View namespace: `tpa::`
- Override any view by copying to your theme at `resources/views/<active-theme>/modules/tripplanneradvanced/`
- Key views
  - `Resources/views/index.blade.php`
  - `Resources/views/create.blade.php`
  - `Resources/views/show.blade.php`
  - `Resources/views/trips_table.blade.php`

## Uninstall
- Disable the module and clear caches.
- Optionally drop the tables created by the migrations (`ch_trip_reports`, `ch_flight_pirep_trip`, `trip_report_user`, `tpa_settings`).

## License (BSD‑3)
Portions derived from CHTrips by Cardinal Horizon. © 2024 Cardinal Horizon.

Provided under the BSD‑3 license with attribution. See original CHTrips license for details.

## Packaging
- Package name: `phpvms-addons/trip-planner-advanced`
- Module alias: `tripplanneradvanced`; namespace: `Modules\TripPlannerAdvanced`; views: `tpa::`
- Zip the `TripPlannerAdvanced` folder (preserve this README) for release.
