@extends('tpa::layouts.frontend')

@section('title', 'Trip Planner')

@section('content')

  <div class="mb-3">
    <a href="{{ route('tripplanner.index') }}" class="btn btn-sm btn-outline-secondary">← Back to My Trips</a>
  </div>

  <h1>{{$name}}</h1>
  <p>{{$description}}</p>
  <div class="mb-4">
    <div class="text-center">Trip Progress: {{$progress}}%</div>
    <div class="progress">
      <div class="progress-bar" role="progressbar" style="width: {{$progress}}%" aria-valuenow="{{$progress}}" aria-valuemin="0" aria-valuemax="100"></div>
    </div>
  </div>
  @if(isset($pireps) && $pireps->count() > 0)
    @include('pireps.table')
  @endif
  @if($flight)
    <h3>Next Flight</h3>
    <div class="card">
      <div class="card-body" style="min-height: 0">
        <div class="row">
          <div class="col-sm-12">
            <div>{{ $flight->airline->name }} <span class="float-right">{{\App\Models\Enums\FlightType::label($flight->flight_type)}}</span></div>
            <div style="font-size: 32px; line-height: 32px; font-weight: 600">


              {{ $flight->ident }}
              @if(filled($flight->callsign) && !setting('simbrief.callsign', true))
                {{ '| '. $flight->atc }}
              @endif
              <span class="float-right">🛫 {{$flight->dpt_airport_id}} → 🛬 {{$flight->arr_airport_id}}</span>
            </div>
          </div>
          <div class="col-sm-3 align-top text-right">
            {{--
            !!! NOTE !!!
             Don't remove the "save_flight" class, or the x-id attribute.
             It will break the AJAX to save/delete

             "x-saved-class" is the class to add/remove if the bid exists or not
             If you change it, remember to change it in the in-array line as well
            --}}

          </div>
        </div>
        <div class="row">
          <div class="col-sm-12">
            {{--
            <span class="title">{{ strtoupper(__('flights.dep')) }}&nbsp;</span>
            {{ optional($flight->dpt_airport)->name ?? $flight->dpt_airport_id }}
            (<a href="{{route('frontend.airports.show', ['id' => $flight->dpt_airport_id])}}">{{$flight->dpt_airport_id}}</a>)
            @if($flight->dpt_time), {{ $flight->dpt_time }}@endif
            <br/>
            <span class="title">{{ strtoupper(__('flights.arr')) }}&nbsp;</span>
            {{ optional($flight->arr_airport)->name ?? $flight->arr_airport_id }}
            (<a href="{{route('frontend.airports.show', ['id' => $flight->arr_airport_id])}}">{{$flight->arr_airport_id}}</a>)
            @if($flight->arr_time), {{ $flight->arr_time }}@endif
            <br/>
            @if(filled($flight->callsign) && !setting('simbrief.callsign', true))
              <span class="title">{{ strtoupper(__('flights.callsign')) }}&nbsp;</span>
              {{ $flight->atc }}
              <br/>
            @endif
            @if($flight->distance)
              <span class="title">{{ strtoupper(__('common.distance')) }}&nbsp;</span>
              {{ $flight->distance }} {{ setting('units.distance') }}
              <br/>
            @endif
            @if($flight->level)
              <span class="title">{{ strtoupper(__('flights.level')) }}&nbsp;</span>
              {{ $flight->level }} {{ setting('units.altitude') }}
              <br/>
            @endif
            --}}
            @if($flight->subfleets)
              @php
                $arr = [];
                foreach ($flight->subfleets as $sf) {
                    $arr[] = "{$sf->type}";
                }
                $aircraft_list = implode(", ", $arr);
              @endphp
              <span class="badge rounded-pill bg-info text-dark" tabindex="0"
                    data-bs-toggle="popover" data-bs-trigger="hover focus" data-bs-placement="top" data-bs-html="true"
                    data-bs-container="body" title="Aircraft included" data-bs-content="{{ $aircraft_list }}">
                Aircraft included
              </span>
              <br/>
            @endif
          </div>
          <div class="col-sm-5">
            @if($flight->route)
              <span class="title">{{ strtoupper(__('flights.route')) }}&nbsp;</span>
              {{ $flight->route }}
            @endif
          </div>
        </div>
      </div>
      <div class="card-footer d-flex justify-content-between align-items-center flex-wrap">
        <div class="btn-group btn-group-sm mb-2 mb-sm-0" role="group" aria-label="Primary actions">
          <a class="btn btn-outline-info" href="{{ route('frontend.flights.show', [$flight->id]) }}">More Info</a>
          @php $bidAircraftId = isset($saved[$flight->id]) ? App\Models\Bid::find($saved[$flight->id])->aircraft_id : null; @endphp
          <a href="{{ route('tripplanner.pireps.create') }}?flight_id={{ $flight->id }}@if($bidAircraftId)&aircraft_id={{ $bidAircraftId }} @endif" class="btn btn-outline-info">
            {{ __('pireps.newpirep') }}
          </a>
          @if ($simbrief !== false)
            @if ($flight->simbrief && $flight->simbrief->user_id === $user->id)
              <a href="{{ route('frontend.simbrief.briefing', $flight->simbrief->id) }}" class="btn btn-outline-primary">View SimBrief</a>
            @else
              @if ($simbrief_bids === false || ($simbrief_bids === true && isset($saved[$flight->id])))
                <a href="{{ route('frontend.simbrief.generate') }}?flight_id={{ $flight->id }}@if($bidAircraftId)&aircraft_id={{ $bidAircraftId }} @endif&ignore_loc=1" class="btn btn-outline-primary">Create SimBrief</a>
              @endif
            @endif
          @endif
          @php
            $tpa = \Modules\TripPlannerAdvanced\Models\TpaSettings::first();
            $allowAdd = true;
            if ($tpa && $tpa->lock_to_current_location) {
              $allowAdd = !setting('pilots.only_flights_from_current') || ($flight->dpt_airport_id == optional($user->current_airport)->icao);
            }
          @endphp
          @if ($allowAdd)
            <button class="btn save_flight {{ isset($saved[$flight->id]) ? 'btn-success':'btn-outline-success' }}"
                    x-id="{{ $flight->id }}"
                    x-saved-class="btn-success"
                    x-not-saved-class="btn-outline-success" type="button"
                    title="@lang('flights.addremovebid')">
              {{ isset($saved[$flight->id]) ? 'Remove Bid' : 'Add Bid' }}
            </button>
          @endif
        </div>

        <div class="secondary-actions text-right">
          @if ($acars_plugin)
            @if (isset($saved[$flight->id]))
              <a href="vmsacars:bid/{{ $saved[$flight->id] }}" class="btn btn-sm btn-outline-primary">Load in vmsACARS</a>
            @else
              <a href="vmsacars:flight/{{ $flight->id }}" class="btn btn-sm btn-outline-primary">Load in vmsACARS</a>
            @endif
          @endif

        </div>
      </div>
    </div>
  @endif

  @if(!$lockToCurrent && $autoReposition && ($completedCount ?? 0) === 0)
    <div class="alert alert-info mt-3">
      Note: Because this trip allows starting from any location, you will be automatically repositioned to the first departure airport after placing your first Bid.
    </div>
  @endif

  @if($upcoming)
  <h3 class="mt-4">Following Flights</h3>
  @foreach($upcoming as $flight)
    <div class="card">
      <div class="card-body" style="min-height: 0">
        <div class="row">
          <div class="col-sm-12">
            <div>{{ $flight->airline->name }} <span class="float-right">{{\App\Models\Enums\FlightType::label($flight->flight_type)}}</span></div>
            <div style="font-size: 32px; line-height: 32px; font-weight: 600">


              {{ $flight->ident }}
              @if(filled($flight->callsign) && !setting('simbrief.callsign', true))
                {{ '| '. $flight->atc }}
              @endif
              <span class="float-right">🛫 {{$flight->dpt_airport_id}} → 🛬 {{$flight->arr_airport_id}}</span>
            </div>
          </div>
          <div class="col-sm-3 align-top text-right">
            {{--
            !!! NOTE !!!
             Don't remove the "save_flight" class, or the x-id attribute.
             It will break the AJAX to save/delete

             "x-saved-class" is the class to add/remove if the bid exists or not
             If you change it, remember to change it in the in-array line as well
            --}}

          </div>
        </div>
        <div class="row">
          <div class="col-sm-12">
            {{--
            <span class="title">{{ strtoupper(__('flights.dep')) }}&nbsp;</span>
            {{ optional($flight->dpt_airport)->name ?? $flight->dpt_airport_id }}
            (<a href="{{route('frontend.airports.show', ['id' => $flight->dpt_airport_id])}}">{{$flight->dpt_airport_id}}</a>)
            @if($flight->dpt_time), {{ $flight->dpt_time }}@endif
            <br/>
            <span class="title">{{ strtoupper(__('flights.arr')) }}&nbsp;</span>
            {{ optional($flight->arr_airport)->name ?? $flight->arr_airport_id }}
            (<a href="{{route('frontend.airports.show', ['id' => $flight->arr_airport_id])}}">{{$flight->arr_airport_id}}</a>)
            @if($flight->arr_time), {{ $flight->arr_time }}@endif
            <br/>
            @if(filled($flight->callsign) && !setting('simbrief.callsign', true))
              <span class="title">{{ strtoupper(__('flights.callsign')) }}&nbsp;</span>
              {{ $flight->atc }}
              <br/>
            @endif
            @if($flight->distance)
              <span class="title">{{ strtoupper(__('common.distance')) }}&nbsp;</span>
              {{ $flight->distance }} {{ setting('units.distance') }}
              <br/>
            @endif
            @if($flight->level)
              <span class="title">{{ strtoupper(__('flights.level')) }}&nbsp;</span>
              {{ $flight->level }} {{ setting('units.altitude') }}
              <br/>
            @endif
            --}}
            @if($flight->subfleets)
              @php
                $arr = [];
                foreach ($flight->subfleets as $sf) {
                    $arr[] = "{$sf->type}";
                }
                $aircraft_list = implode(", ", $arr);
              @endphp
              <span class="badge rounded-pill bg-info text-dark" tabindex="0"
                    data-bs-toggle="popover" data-bs-trigger="hover focus" data-bs-placement="top" data-bs-html="true"
                    data-bs-container="body" title="Aircraft included" data-bs-content="{{ $aircraft_list }}">
                Aircraft included
              </span>
              <br/>
            @endif
          </div>
          <div class="col-sm-5">
            @if($flight->route)
              <span class="title">{{ strtoupper(__('flights.route')) }}&nbsp;</span>
              {{ $flight->route }}
            @endif
          </div>
        </div>
      </div>
    </div>
  @endforeach
  @endif
  @if (setting('bids.block_aircraft', false))
    @include('flights.bids_aircraft')
  @endif
@endsection
@include('tpa::scripts')
