<?php

namespace Modules\DestinationsMap\Providers;

use Illuminate\Support\Facades\Route;
use Illuminate\Foundation\Support\Providers\RouteServiceProvider as ServiceProvider;

class RouteServiceProvider extends ServiceProvider
{
    protected $namespace = 'Modules\\DestinationsMap\\Http\\Controllers';

    public function map(): void
    {
        $this->mapWebRoutes();
        $this->mapApiRoutes();
    }

    protected function mapWebRoutes(): void
    {
        Route::middleware(['web', 'auth'])
            ->namespace($this->namespace.'\\Frontend')
            ->group(__DIR__.'/../Routes/web.php');
    }

    protected function mapApiRoutes(): void
    {
        Route::middleware(['web', 'auth'])
            ->namespace($this->namespace.'\\Api')
            ->prefix('modules/destinations-map')
            ->as('modules.destinationsmap.')
            ->group(__DIR__.'/../Routes/api.php');
    }
}

