<?php

namespace Modules\DestinationsMap\Providers;

use App\Contracts\Modules\ServiceProvider;
use App\Services\ModuleService;

class AppServiceProvider extends ServiceProvider
{
    protected ModuleService $moduleSvc;

    public function boot(): void
    {
        $this->moduleSvc = app(ModuleService::class);
        $this->registerViews();
        $this->registerLinks();
    }

    public function registerLinks(): void
    {
        // Frontend link, members-only; American nav groups handle rendering/order via CreationCrew Menu
        // We still register a generic link for Seven/Beta if ever used.
        $this->moduleSvc->addFrontendLink('Destinations Map', '/destinations-map', 'bi bi-geo', true);
    }

    public function registerViews(): void
    {
        $viewPath = resource_path('views/modules/destinationsmap');
        $sourcePath = __DIR__.'/../Resources/views';

        $this->publishes([$sourcePath => $viewPath,], 'views');

        $paths = array_map(function ($path) {
            return str_replace('default', setting('general.theme'), $path).'/modules/destinationsmap';
        }, config('view.paths'));

        $this->loadViewsFrom(array_merge($paths, [$sourcePath]), 'destinationsmap');
    }
}

