# Destinations Map (phpVMS v7 Module)

A modern, interactive Destinations Map for phpVMS v7. It lets pilots pick an origin, discover all available direct and connecting destinations, and view the matching schedules in a compact table. It can also display a richer ACARS “Flight Board” for current flights.

This module is production‑ready for the American/CreationCrew theme and also works with Seven/Beta themes.

---

## Features
- Airline selector to filter routes (all airlines or a specific airline)
- Clickable map of available origins and destinations
- Direct and connecting destination discovery
- Schedules table with:
  - Airline logo + ident
  - Departure/Arrival icons
  - Details link and Bid button wiring (uses existing site patterns)
- ACARS Flight Board
  - Logo, Pilot, Flight, Aircraft, Dep/Arr, Altitude, Groundspeed, Distance, Status
- Caches nothing itself; reads directly from your phpVMS routes and ACARS APIs
- Minimal, theme‑safe Blade template; no database changes

---

## Requirements
- phpVMS v7 (current)
- Authenticated users (routes are behind `web` + `auth` middleware by default)
- Existing flights data (Schedules) and the core ACARS API if you want the Flight Board

---

## Installation
1) Copy the folder `modules/DestinationsMap` into your phpVMS v7 install (same modules directory level as other modules).

2) Clear caches (recommended):
- Admin > Maintenance > Clear Cache, or artisan: `php artisan cache:clear` and `php artisan view:clear`

3) Visit the page:
- URL: `/destinations-map`
- Named routes:
  - Frontend page: `destinationsmap.index`
  - Module JSON API (prefixed): `/destinations-map/*`
    - `GET /airlines`
    - `GET /origins?airline_id=<id>`
    - `GET /destinations?origin=<ICAO>&airline_id=<id>`
    - `GET /connecting?airport=<ICAO>&exclude=<ICAO>&airline_id=<id>`
    - `GET /schedules?origin=<ICAO>&destination=<ICAO>&airline_id=<id>`

---

## Theme integration
- CreationCrew/American: the menu item is injected just below “Live Map” within the Resources group. If your CreationCrew Menu Manager doesn’t show it, it will still appear under Resources as “Destinations Map”.
- Seven/Beta: the Provider also registers a generic frontend link so it can be surfaced by the default nav include that lists module links for logged‑in users.

---

## Files Overview
- Providers
  - `Providers/AppServiceProvider.php`: registers views and the generic frontend link
  - `Providers/RouteServiceProvider.php`: wires `web` (page) and `api` (module endpoints)
- Routes
  - `Routes/web.php`: `/destinations-map` page
  - `Routes/api.php`: lightweight JSON endpoints used by the page
- Controllers
  - `Http/Controllers/Frontend/IndexController.php`: serves the Blade page
  - `Http/Controllers/Api/MapController.php`: origins/destinations/schedules endpoints
- Views
  - `Resources/views/index.blade.php`: Leaflet UI + schedules table + optional Flight Board

No database migrations are required.

---

## Permissions
- The page and endpoints are behind `auth` in the module RouteServiceProvider. If you want to allow guest access, change the middleware in `Providers/RouteServiceProvider.php` from `['web','auth']` to `['web']` for the web/api groups.

---

## Customization
- Height: change `map_height` passed from `IndexController`
- Icons: we use Bootstrap Icons CDN for small airplane icons; feel free to swap
- Schedules table: edit the Blade to add/remove columns
- ACARS board: status badge color coding can be added easily (phase-based)

---

## Uninstall / Remove
- Simply delete the `modules/DestinationsMap` folder; no DB changes were made
- Remove any custom theme menu injections if you copied them elsewhere

---

## Changelog (high‑level)
- v1.0.0
  - Initial community release
  - Airline filtering, origin/destination/connecting discovery
  - Schedules table with logos and dep/arr icons
  - Optional ACARS Flight Board

---

## Support
Open an issue in the repository where you obtained this module, or contact the author in the phpVMS community channels.

