<?php

namespace Modules\ModuleCenter\Providers;

use Illuminate\Foundation\Support\Providers\RouteServiceProvider as ServiceProvider;
use Illuminate\Routing\Router;
use Illuminate\Support\Facades\Route;
use Modules\ModuleCenter\Http\Controllers\Admin\ModuleCenterController;

class RouteServiceProvider extends ServiceProvider
{
    protected $namespace = 'Modules\\ModuleCenter\\Http\\Controllers';

    public function before(Router $router)
    {
        //
    }

    public function map(Router $router)
    {
        $this->registerAdminRoutes();
    }

    protected function registerAdminRoutes(): void
    {
        $config = [
            'as'         => 'admin.modulecenter.',
            'prefix'     => 'admin/modulecenter',
            'namespace'  => $this->namespace.'\\Admin',
            'middleware' => ['web', 'auth', 'ability:admin,settings'],
        ];

        Route::group($config, function () {
            Route::get('/', [ModuleCenterController::class, 'index'])->name('index'); // Installed view
            Route::get('/catalog', [ModuleCenterController::class, 'catalog'])->name('catalog');
            Route::post('/refresh', [ModuleCenterController::class, 'refreshCatalog'])->name('refresh');
            Route::post('/unlock', [ModuleCenterController::class, 'unlock'])->name('unlock');
            Route::post('/install', [ModuleCenterController::class, 'install'])->name('install');
            Route::post('/install-url', [ModuleCenterController::class, 'installFromUrl'])->name('install-url');
            Route::post('/download', [ModuleCenterController::class, 'download'])->name('download');
        });
    }
}

