@extends('admin.app')
@section('title', 'Module Center  Installed')

@section('content')
  <div class="row">
    <div class="col-md-12">
      <div class="card border-blue-bottom mb-3">
        <div class="header d-flex justify-content-between align-items-center">
          <h4 class="title mb-0">Installed Modules</h4>
          <div>
            <a href="{{ route('admin.modulecenter.catalog') }}" class="btn btn-sm btn-outline-secondary">Catalog</a>
          </div>
        </div>
        <div class="content">
          <ul class="mb-3">
            <li>Zip extension: <strong class="{{ $preflight['zip_extension'] ? 'text-success' : 'text-danger' }}">{{ $preflight['zip_extension'] ? 'OK' : 'Missing' }}</strong></li>
            <li>Modules folder writable: <strong class="{{ $preflight['modules_writable'] ? 'text-success' : 'text-danger' }}">{{ $preflight['modules_writable'] ? 'OK' : 'Not writable' }}</strong></li>
            <li>storage/app/module_downloads: <strong class="{{ $preflight['downloads_writable'] ? 'text-success' : 'text-danger' }}">{{ $preflight['downloads_writable'] ? 'OK' : 'Createable?' }}</strong></li>
            <li>storage/app/module_backups: <strong class="{{ $preflight['backups_writable'] ? 'text-success' : 'text-danger' }}">{{ $preflight['backups_writable'] ? 'OK' : 'Createable?' }}</strong></li>
          </ul>
          @if($needs_update)
            <a href="/update" class="btn btn-sm btn-primary">Run updates</a>
          @endif
        </div>
      </div>
    </div>
  </div>

  <div class="row">
    <div class="col-md-12">
      <div class="card border-blue-bottom">
        <div class="header"><h4 class="title">Modules</h4></div>
        <div class="content">
          <div class="table-responsive">
            <table class="table">
              <thead>
                <tr>
                  <th>Name</th>
                  <th>Alias</th>
                  <th>Version</th>
                  <th>Status</th>
                  <th>Update</th>
                </tr>
              </thead>
              <tbody>
                @forelse($installed as $m)
                  <tr>
                    <td>{{ $m['name'] }}</td>
                    <td class="text-muted small">{{ $m['alias'] }}</td>
                    <td>@if(!empty($m['version'])) v{{ $m['version'] }} @else <span class="text-muted">n/a</span> @endif</td>
                    <td>
                      @if(!empty($m['active']))
                        <span class="badge bg-success">Active</span>
                      @else
                        <span class="badge bg-secondary">Inactive</span>
                      @endif
                    </td>
                    <td>
                      @php($lookup = $m['lookup'] ?? null)
                      @if(isset($lookup) && isset($catalog_index[$lookup]))
                        @php($remote = $catalog_index[$lookup])
                        @if(!empty($remote['version']) && !empty($m['version']) && version_compare($remote['version'], $m['version'], '>'))
                          <span class="badge bg-warning text-dark">Update to v{{ $remote['version'] }}</span>
                          <a href="{{ route('admin.modulecenter.catalog') }}" class="btn btn-xs btn-outline-secondary ms-2">Open in Catalog</a>
                        @else
                          <span class="badge bg-secondary">Up to date</span>
                        @endif
                      @else
                        <a href="{{ route('admin.modulecenter.catalog') }}" class="btn btn-xs btn-outline-secondary">Check Catalog</a>
                      @endif
                    </td>
                  </tr>
                @empty
                  <tr><td colspan="5"><em>No modules installed.</em></td></tr>
                @endforelse
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>
  </div>
@endsection

