@extends('admin.app')
@section('title', 'Module Center — Installed')

@section('content')
  <div class="row">
    <div class="col-md-12">
      <div class="card border-blue-bottom mb-3">
        <div class="header d-flex justify-content-between align-items-center">
          <h4 class="title mb-0">Installed Modules</h4>
          <div>
            <a href="{{ route('admin.modulecenter.catalog') }}" class="btn btn-sm btn-primary">Catalog</a>
          </div>
        </div>
        <div class="content">
          <ul class="mb-3">
            <li>Zip extension: <strong class="{{ $preflight['zip_extension'] ? 'text-success' : 'text-danger' }}">{{ $preflight['zip_extension'] ? 'OK' : 'Missing' }}</strong></li>
            <li>Modules folder writable: <strong class="{{ $preflight['modules_writable'] ? 'text-success' : 'text-danger' }}">{{ $preflight['modules_writable'] ? 'OK' : 'Not writable' }}</strong></li>
            <li>storage/app/module_downloads: <strong class="{{ $preflight['downloads_writable'] ? 'text-success' : 'text-danger' }}">{{ $preflight['downloads_writable'] ? 'OK' : 'Createable?' }}</strong></li>
            <li>storage/app/module_backups: <strong class="{{ $preflight['backups_writable'] ? 'text-success' : 'text-danger' }}">{{ $preflight['backups_writable'] ? 'OK' : 'Createable?' }}</strong></li>
          </ul>
          @if($needs_update)
            <div style="display:flex;align-items:center;column-gap:8px;row-gap:8px;flex-wrap:wrap">
              <a href="/update" class="btn btn-sm btn-primary" style="display:inline-block">Run updates</a>
              <form method="POST" action="{{ route('admin.maintenance.cache') }}" style="display:inline-block;margin:0">
                @csrf
                <input type="hidden" name="type" value="all" />
                <button type="submit" class="btn btn-sm btn-default">Clear all Cache</button>
              </form>
            </div>
          @endif
        </div>
      </div>
    </div>
  </div>

  <div class="row">
    <div class="col-md-12">
      <div class="card border-blue-bottom">
        <div class="header"><h4 class="title">Modules</h4></div>
        <div class="content">
          @if(session('status'))
            <div class="alert alert-success">{{ session('status') }}</div>
          @endif
          @if($errors->any())
            <div class="alert alert-danger">
              <ul class="mb-0">
                @foreach($errors->all() as $e)
                  <li>{{ $e }}</li>
                @endforeach
              </ul>
            </div>
          @endif
          <div class="table-responsive">
            <table class="table">
              <thead>
                <tr>
                  <th>Module</th>
                  <th>Alias</th>
                  <th>Installed</th>
                  <th>Status</th>
                  <th>Version</th>
                  <th>Update</th>
                </tr>
              </thead>
              <tbody>
                @forelse($installed as $m)
                  <tr>
                    <td>
                      <div>{{ $m['name'] }}</div>
                      @if(!empty($m['description']))
                        <div class="small" style="color:#333;">{{ $m['description'] }}</div>
                      @endif
                    </td>
                    <td class="text-muted small">{{ $m['alias'] }}</td>
                    <td>
                      @if(!empty($m['installed_ok']))
                        <span class="label label-success">OK</span>
                      @else
                        <span class="label label-danger">Issue</span>
                      @endif
                    </td>
                    <td>
                      @if($m['active'])
                        <span class="label label-success">Active</span>
                      @else
                        <span class="label label-default">Not active</span>
                      @endif
                    </td>
                    <td>@if(!empty($m['version'])) v{{ $m['version'] }} @else <span class="text-muted">n/a</span> @endif</td>
                    <td>
                      @php($lookup = $m['lookup'] ?? null)
                      @php($remote = isset($lookup) && isset($catalog_index[$lookup]) ? $catalog_index[$lookup] : null)
                      @if($remote && !empty($m['update_available']))
                        @if(!empty($m['can_update']))
                          <form method="POST" action="{{ route('admin.modulecenter.install') }}" class="d-inline">
                            @csrf
                            <input type="hidden" name="alias" value="{{ $remote['alias'] ?? $m['alias'] }}" />
                            <button class="btn btn-xs btn-primary">Update to v{{ $remote['version'] }}</button>
                          </form>
                          <form method="POST" action="{{ route('admin.modulecenter.download') }}" class="d-inline" style="margin-left:6px;">
                            @csrf
                            <input type="hidden" name="alias" value="{{ $remote['alias'] ?? $m['alias'] }}" />
                            <button class="btn btn-xs btn-default" title="Download the ZIP without installing">Download only</button>
                          </form>
                        @else
                          <span class="label label-warning">Update {{ $remote['version'] }}</span>
                          <small class="text-muted d-block">Unlock to update</small>
                        @endif
                      @elseif($remote && empty($m['update_available']))
                        <span class="label label-default">Up to date</span>
                      @else
                        <span class="label label-default">Unknown</span>
                      @endif
                    </td>
                  </tr>
                @empty
                  <tr><td colspan="5"><em>No modules installed.</em></td></tr>
                @endforelse
              </tbody>
            </table>
          </div>
            <div class="alert alert-warning mt-3" role="alert" style="background-color:#f0ad4e;color:#fff;">
              <div><strong>Warning</strong></div>
              <p class="mb-0">The available UPDATES shown in the table above should only be applied if you have not customized any of the module files. By installing the UPDATE all module files will be overwritten and you will lose ANY customizations you have made.</p>
            </div>

        </div>
      </div>
    </div>
  </div>
@endsection

