<?php

namespace Modules\ModuleCenter\Providers;

use App\Contracts\Modules\ServiceProvider;

class AppServiceProvider extends ServiceProvider
{
    private $moduleSvc;

    protected $defer = false;

    public function boot(): void
    {
        $this->moduleSvc = app('App\\Services\\ModuleService');

        $this->registerViews();
        $this->registerLinks();
        // No migrations in MVP
        // $this->loadMigrationsFrom(__DIR__.'/../Database/migrations');
    }

    public function register()
    {
        // Bindings if needed later
    }

    public function registerLinks(): void
    {
        // Admin link only; keep it simple
        $this->moduleSvc->addAdminLink('Module Center', '/admin/modulecenter', 'pe-7s-plugin');
    }

    public function registerViews(): void
    {
        $viewPath = resource_path('views/modules/modulecenter');
        $sourcePath = __DIR__.'/../Resources/views';

        $this->publishes([$sourcePath => $viewPath], 'views');

        // Load views from theme override path and then our source
        $paths = array_map(function ($path) {
            return str_replace('default', setting('general.theme'), $path).'/modules/modulecenter';
        }, \Config::get('view.paths'));

        $this->loadViewsFrom(array_merge($paths, [$sourcePath]), 'modulecenter');
    }
}

