@extends('admin.app')
@section('title', 'Module Center — Catalog')

@section('content')
  <div class="row">
    <div class="col-md-12">
      <div class="card border-blue-bottom mb-3">
        <div class="header d-flex justify-content-between align-items-center">
          <h4 class="title mb-0">Catalog</h4>
          <div>
            <a href="{{ route('admin.modulecenter.index') }}" class="btn btn-sm btn-primary">Installed</a>
          </div>
        </div>
        <div class="content">
          @if(session('status'))
            <div class="alert alert-success">{{ session('status') }}</div>
          @endif
          @if($errors->any())
            <div class="alert alert-danger">
              <ul class="mb-0">
                @foreach($errors->all() as $e)
                  <li>{{ $e }}</li>
                @endforeach
              </ul>
            </div>
          @endif

          <form method="POST" action="{{ route('admin.modulecenter.refresh') }}" class="d-inline">
            @csrf
            <button class="btn btn-sm btn-outline-secondary">Refresh Catalog</button>
          </form>

        </div>
      </div>
    </div>
  </div>

  <div class="row">
    <div class="col-md-12">
      @php
        $free = [];
        $paid = [];
        foreach ($catalog as $m) {
          if (!empty($m['paid'])) { $paid[] = $m; } else { $free[] = $m; }
        }
      @endphp

      <div class="card border-blue-bottom mb-3" style="padding-left:50px;padding-right:50px;">
        <div class="header"><h4 class="title">Free Community Modules</h4></div>
        <div class="content">
          <div class="row g-3">
            @forelse($free as $mod)
              <div class="col-md-6">
                <div class="card border-blue-bottom h-100">
                  <div class="content">
                    <div class="d-flex align-items-center justify-content-between mb-2">
                      <h5 class="mb-0">{{ $mod['name'] ?? 'Module' }}</h5>
                      <div class="small text-muted">@if(!empty($mod['version'])) v{{ $mod['version'] }} @endif</div>
                    </div>
                    <p class="small mb-3" style="color:#333;">{{ $mod['description'] ?? '' }}</p>

                    @if(!empty($mod['installed']))
                      <div class="mb-2">
                        <span class="label label-success">Installed @if(!empty($mod['installed_version'])) v{{ $mod['installed_version'] }} @endif</span>
                        @if(!empty($mod['update_available']))
                          <span class="label label-warning">Update available @if(!empty($mod['version'])) v{{ $mod['version'] }} @endif</span>
                          <form method="POST" action="{{ route('admin.modulecenter.install') }}" class="d-inline ms-2">
                            @csrf
                            <input type="hidden" name="alias" value="{{ $mod['alias'] ?? ($mod['slug'] ?? '') }}" />
                            <button class="btn btn-sm btn-primary">Update</button>
                          </form>
                          <form method="POST" action="{{ route('admin.modulecenter.download') }}" class="d-inline ms-2">
                            @csrf
                            <input type="hidden" name="alias" value="{{ $mod['alias'] ?? ($mod['slug'] ?? '') }}" />
                            <button class="btn btn-sm btn-default">Download only</button>
                          </form>
                        @else
                          <span class="label label-default">Up to date</span>
                          <form method="POST" action="{{ route('admin.modulecenter.download') }}" class="d-inline ms-2">
                            @csrf
                            <input type="hidden" name="alias" value="{{ $mod['alias'] ?? ($mod['slug'] ?? '') }}" />
                            <button class="btn btn-sm btn-default">Download only</button>
                          </form>
                        @endif
                      </div>
                    @else
                      <form method="POST" action="{{ route('admin.modulecenter.install') }}" class="d-inline mb-0">
                        @csrf
                        <input type="hidden" name="alias" value="{{ $mod['alias'] ?? ($mod['slug'] ?? '') }}" />
                        <button class="btn btn-sm btn-primary">Install</button>
                      </form>
                      <form method="POST" action="{{ route('admin.modulecenter.download') }}" class="d-inline ms-2 mb-0">
                        @csrf
                        <input type="hidden" name="alias" value="{{ $mod['alias'] ?? ($mod['slug'] ?? '') }}" />
                        <button class="btn btn-sm btn-default">Download only</button>
                      </form>
                    @endif
                  </div>
                </div>
              </div>
            @empty
              <div class="col-md-12"><em>No free modules in catalog.</em></div>
            @endforelse
          </div>
        </div>
      </div>

      <div class="card border-blue-bottom mb-3" style="padding-left:50px;padding-right:50px;">
        <div class="header"><h4 class="title">Commercial Modules</h4></div>
        <div class="content">
          <div class="row g-3">
            @forelse($paid as $mod)
              <div class="col-md-6">
                <div class="card border-blue-bottom h-100">
                  <div class="content">
                    <div class="d-flex align-items-center justify-content-between mb-2">
                      <h5 class="mb-0">{{ $mod['name'] ?? 'Module' }}</h5>
                      <div class="small text-muted">@if(!empty($mod['version'])) v{{ $mod['version'] }} @endif</div>
                    </div>
                    <p class="small mb-3" style="color:#333;">{{ $mod['description'] ?? '' }}</p>

                    @if(!empty($mod['installed']))
                      <div class="mb-2">
                        <span class="label label-success">Installed @if(!empty($mod['installed_version'])) v{{ $mod['installed_version'] }} @endif</span>
                        @if(!empty($mod['update_available']))
                          <span class="label label-warning">Update available @if(!empty($mod['version'])) v{{ $mod['version'] }} @endif</span>
                          <form method="POST" action="{{ route('admin.modulecenter.install') }}" class="d-inline ms-2">
                            @csrf
                            <input type="hidden" name="alias" value="{{ $mod['alias'] ?? ($mod['slug'] ?? '') }}" />
                            <button class="btn btn-sm btn-primary">Update</button>
                          </form>
                          @if(!empty($mod['unlocked']))
                          <form method="POST" action="{{ route('admin.modulecenter.download') }}" class="d-inline ms-2">
                            @csrf
                            <input type="hidden" name="alias" value="{{ $mod['alias'] ?? ($mod['slug'] ?? '') }}" />
                            <button class="btn btn-sm btn-default">Download only</button>
                          </form>
                          @endif
                        @else
                          <span class="label label-default">Up to date</span>
                          @if(!empty($mod['unlocked']))
                          <form method="POST" action="{{ route('admin.modulecenter.download') }}" class="d-inline ms-2">
                            @csrf
                            <input type="hidden" name="alias" value="{{ $mod['alias'] ?? ($mod['slug'] ?? '') }}" />
                            <button class="btn btn-sm btn-default">Download only</button>
                          </form>
                          @endif
                        @endif
                      </div>
                    @else
                      @if(!empty($mod['unlocked']))
                        <form method="POST" action="{{ route('admin.modulecenter.install') }}" class="d-inline mb-0">
                          @csrf
                          <input type="hidden" name="alias" value="{{ $mod['alias'] ?? ($mod['slug'] ?? '') }}" />
                          <button class="btn btn-sm btn-primary">Install</button>
                        </form>
                        <form method="POST" action="{{ route('admin.modulecenter.download') }}" class="d-inline ms-2 mb-0">
                          @csrf
                          <input type="hidden" name="alias" value="{{ $mod['alias'] ?? ($mod['slug'] ?? '') }}" />
                          <button class="btn btn-sm btn-default">Download only</button>
                        </form>
                      @else
                        <form method="POST" action="{{ route('admin.modulecenter.unlock') }}" class="d-flex gap-2 mb-0">
                          @csrf
                          <input type="hidden" name="alias" value="{{ $mod['alias'] ?? ($mod['slug'] ?? '') }}" />
                          <input type="text" name="key" class="form-control input-sm" placeholder="Enter license key" required />
                          <button class="btn btn-sm btn-outline-secondary">Unlock</button>
                        </form>
                      @endif
                    @endif
                  </div>
                </div>
              </div>
            @empty
              <div class="col-md-12"><em>No commercial modules in catalog.</em></div>
            @endforelse
          </div>
        </div>
      </div>
    </div>
  </div>

  <div class="row">
    <div class="col-md-12">
      <div class="card border-blue-bottom mb-3" style="padding-left:50px;padding-right:50px;">
        <div class="header"><h4 class="title">Manual Install (URL)</h4></div>
        <div class="content">
          <form method="POST" action="{{ route('admin.modulecenter.install-url') }}" class="mb-2">
            @csrf
            <div class="form-group mb-2">
              <label>ZIP URL</label>
              <input type="url" name="url" class="form-control" placeholder="https://example.com/YourModule.zip" required />
            </div>
            <button class="btn btn-sm btn-primary">Install from URL</button>
          </form>
          <p class="text-muted small mt-2">After installation, click "Run updates" to complete database migrations.</p>
        </div>
      </div>
    </div>
  </div>
@endsection

