<?php

namespace Modules\ModuleCenter\Services;

class PreflightService
{
    public function run(): array
    {
        $checks = [];
        $checks['zip_extension'] = extension_loaded('zip');

        $mods = base_path('Modules');
        // Normalize for vanilla; modules folder is lowercase
        $mods = base_path('modules');

        $checks['modules_exists'] = is_dir($mods);
        $checks['modules_writable'] = is_dir($mods) && is_writable($mods);

        $downloads = storage_path('app/module_downloads');
        $backups   = storage_path('app/module_backups');
        $checks['downloads_writable'] = $this->isWritableDir($downloads);
        $checks['backups_writable']   = $this->isWritableDir($backups);

        return $checks;
    }

    private function isWritableDir(string $path): bool
    {
        if (!is_dir($path)) {
            return is_writable(dirname($path));
        }
        return is_writable($path);
    }
}

